<?php

namespace App\Console\Commands;

use App\Models\Transaksi;
use Carbon\Carbon;
use Illuminate\Console\Command;

class DeleteOldTransferProofs extends Command
{
    protected $signature = 'app:delete-old-transfer-proofs';
    protected $description = 'Delete transfer proofs older than 3 days';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $expiredDate = Carbon::now()->subDays(2);

        $transaksi = Transaksi::where('created_at', '<', $expiredDate)
            ->whereNotNull('bukti_transfer')
            ->get();

        foreach ($transaksi as $data) {
            $filePath = public_path('public/storage/' . $data->bukti_transfer);

            if (file_exists($filePath)) {
                unlink($filePath);
            }

            $data->update(['bukti_transfer' => null]);
        }

        $this->info('Transfer proofs older than 3 days have been deleted successfully.');
    }
}
