<?php

namespace App\Http\Api;

use App\Models\Setting;
use Illuminate\Support\Facades\Http;

class Notification
{
    
    public $token;

    public function __construct()
    {
        $this->token = Setting::pluck('fonte_token')->first();
    }

    public function depositNew($target, $nominal)
    {
        $total = 'Rp ' . number_format($nominal, 0, ',', '.');
        $response = Http::withHeaders([
            'Authorization' => $this->token,
        ])->post('https://api.fonnte.com/send', [
            'target' => $target,
            'message' => 'Anda melakukan deposit manual dengan jumlah ' . '*' . $total . '*' .' Mohon lakukan pembayaran sebelum *Expired*',
        ]);

        return $response->json();
    }

    public function depositQris($target, $nominal, $qris)
    {
        $total = 'Rp ' . number_format($nominal, 0, ',', '.');
        $response = Http::withHeaders([
            'Authorization' => $this->token,
        ])->post('https://api.fonnte.com/send', [
            'target' => $target,
            'message' => 'Anda melakukan deposit QRIS Otomatis dengan jumlah ' . '*' . $total . '*' .' Mohon lakukan pembayaran sebelum *Expired*. Bayar disini : ' . $qris, 
        ]);

        return $response->json();
    }

    public function adminConfirm($target, $nominal)
    {
        $total = 'Rp ' . number_format($nominal, 0, ',', '.');
        $response = Http::withHeaders([
            'Authorization' => $this->token,
        ])->post('https://api.fonnte.com/send', [
            'target' => $target,
            'message' => 'Terimakasih, deposit anda dengan total ' . $total . ' telah di konfirmasi admin.',
        ]);

        return $response->json();
    }
}
