<?php

namespace App\Http\Api;

use App\Models\Api;

class ngaming
{
    public $agent;
    public $signature;
    public $url;

    public function __construct()
    {
        $apiData = Api::first();

        $this->agent = $apiData->ng_agent_code;
        $this->signature = $apiData->ng_signature;
        $this->url = $apiData->ng_endpoint;
    }

    public function createMember($username)
    {
        $cmd = "create_member";
        $postdata = http_build_query([
            'method' => 'user_create',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature,
            'user_code' => $username
        ]);

        return $this->ln_connect($postdata);
    }

    public function depositMember($username, $amount)
    {
        $trx = rand();
        $cmd = "deposit_member";
        $postdata = http_build_query([
            'method' => 'user_deposit',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature,
            'user_code' => $username,
            'amount' => $amount,
            'trx' => $trx
        ]);

        return $this->ln_connect($postdata);
    }

    public function withdrawMember($username, $amount)
    {
        $trx = rand();
        $cmd = "withdraw_member";
        $postdata = http_build_query([
            'method' => 'user_deposit',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature,
            'user_code' => $username,
            'amount' => $amount,
            'trx' => $trx
        ]);

        return $this->ln_connect($postdata);
    }

    public function launchGame($username, $gameCode, $gameProvider, $gameType)
    {
        $cmd = "launch_game";
        $postdata = http_build_query([
            'method' => 'game_launch',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature,
            'user_code' => $username,
            'game_code' => $gameCode,
            'provider_code' => $gameProvider,
            'game_type' => $gameType
        ]);

        return $this->ln_connect($postdata);
    }

    public function infoMember($username)
    {
        $cmd = "info_member";
        $postdata = http_build_query([
            'method' => 'money_info',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature,
            'user_code' => $username
        ]);

        return $this->ln_connect($postdata);
    }

    public function infoAgent()
    {
        $cmd = "info_agent";
        $postdata = http_build_query([
            'method' => 'money_info',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature
        ]);

        return $this->ln_connect($postdata);
    }

    public function providerList()
    {
        $cmd = "info_list_provider";
        $postdata = http_build_query([
            'method' => 'provider_list',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature
            ]);
        
        return $this->ln_connect($postdata);
            
    }

    public function gameList($provider)
    {
        $cmd = "info_list_game";
        $postdata = http_build_query([
            'method' => 'game_list',
            'agent_code' => $this->agent,
            'agent_token' => $this->signature,
            'provider_code' => $provider
            ]);
        
        return $this->ln_connect($postdata, $cmd);
            
    }

    public function betHistory()
    {
        $cmd = "info_bet_history";
        $postdata = http_build_query([
            'user_agent' => $this->agent,
            'signature' => $this->signature
            ]);
        
        return $this->ln_connect($postdata, $cmd);
            
    }

    private function ln_connect($postdata)
    {
        $url = $this->url;
    
        $headerArray = ['Content-Type: application/json'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.47 Safari/537.36');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
}

$DF = new ngaming();
