<?php

namespace App\Http\Controllers;

use App\Http\Api\bgx;
use App\Http\Api\fiver;
use App\Http\Api\ngaming;
use App\Http\Api\sgx;
use App\Http\Api\softgaming;
use App\Models\Fiver_Game;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\Controller;
use App\Models\BgxGame;
use App\Models\NgProvider;
use App\Models\SgProvider;
use App\Models\SgxProvider;
use GuzzleHttp\Client;
use App\Models\SgGame;

class AddGameController extends Controller
{
    public function games()
    { 
        $DF = new ngaming();
        $provider = 'PR';
        $response = $DF->gamelist($provider);
        $decodedResponse = json_decode($response, true);
        return $decodedResponse;

        if (is_array($decodedResponse)) {
            foreach ($decodedResponse['games'] as $game) {
                SgGame::updateOrCreate(
                    ['game_code' => $game['game_code']
                    ],
                    [
                        'game_name' => $game['game_name'],
                        'game_code' => $game['game_code'],
                        'game_image' => $game['game_image'],
                        'game_image' => 'https://assetshst.site/' . $provider . '/' . $game['game_code'] . '.png',
                    ]
                );
            }
        }
        return $decodedResponse;
    }
    
    public function provider(Request $request)
    {
        $DF = new ngaming();
        $response = json_decode($DF->providerList(), true);

        // return $response;
        if (is_array($response)) {
            foreach ($response['data'] as $provider) {
                NgProvider::create([
                    'provider_code' => $provider['provider_code'],
                    'provider_name' => $provider['provider_name'],
                    'provider_type' => $provider['provider_type'],
                    'provider_status' => $provider['provider_status'],
                    'provider_image' => $provider['provider_image'],
                ]);
            }

        }
        return response()->json($response);

    }

    public function deleteGames()
    {
        // Menggunakan Eloquent
        // FiverGame::whereBetween('id', [2015, 2220])->delete();

        // Atau, menggunakan Query Builder
        DB::table('fiver_games')->whereBetween('id', [3578, 4277])->delete();

        return response()->json(['message' => 'Data berhasil dihapus'], 200);
    }
}
