<?php

namespace App\Http\Controllers\Auth;

use App\Http\Api\bgx;
use App\Http\Api\fiver;
use App\Http\Api\gamingsoft;
use App\Http\Api\wokakse;
use App\Http\Api\sgx;
use App\Http\IP\IP;
use App\Models\User;
use App\Models\Saldo;
use App\Models\Network;
use Illuminate\Support\Str;
use App\Http\Api\softgaming;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Mail\OtpMail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Providers\RouteServiceProvider;
use Carbon\Carbon;
// use Illuminate\Support\Facades\Request;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Mail;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;
    protected function redirectTo()
    {
        // if (auth()->user()->level == 'Admin' || auth()->user()->level == 'Developer') {
        //     return '/backoffice';
        // }
        return '/';
    }
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255', 'unique:users'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:4', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        function replace($arrayData) {
            $newstr = preg_replace('/[^a-zA-Z0-9\']/', '', $arrayData);
            $newstr = str_replace("'", '', $newstr);
            return $newstr;
        }
        $refferalcode = strtoupper(Str::random(11));
        $domain = URL::to('/');
        $Url = $domain . '/referral-register?ref=' . $refferalcode;
        $extplayer = $data['name'] . mt_rand(100, 1000);
        $username = $data['name'];
        $otpExpiration = Carbon::now()->addMinutes(10);
        $otp = mt_rand(100000, 999999);
        
        if ($data['password_confirmation'] !== $data['password']) {
            return redirect()->back()->with('error', 'Kata sandi tidak sama.');
        }
        if (empty($data['bank_name'])) {
            return redirect()->back()->with('error', 'Maaf anda belum memilih Bank.');
        }
        // Create Account to NX
        $NX = new fiver();
        $act = json_decode($NX->create($username));
        if ($act->status == 1) {
            $user = User::create([
                'extplayer' => $extplayer,
                'name' => $data['name'],
                'email' => $data['email'],
                'password' => Hash::make($data['password']),
                'telp' => $data['mobile_no'],
                'ref_code' => $refferalcode,
                'ref_link' => $Url,
              	'status_reff' => 0,
                'nama_rek' => $data['acc_name'],
                'bank' => $data['bank_name'],
                'no_rek' => $data['acc_no'],
                'ip_register' => $data['ip_register'],
                'token' => Str::random(7),
                'otp' => $otp,
                'otp_expiration' => $otpExpiration,
            ]);
            $saldo = new Saldo();
            $saldo->user_id = $user->id;
            $saldo->user_name = $user->name;
            $saldo->saldo = 0;
            $saldo->bonus = 0;
            $saldo->save();
    
            if (isset($data['ref_code'])) {
                $UserData = User::where('ref_code', $data['ref_code'])->first();
                if ($UserData) {
                    Network::create([
                        'user_id' => $user->id,
                        'ref_code' => $data['ref_code'],
                        'username' => replace($data['name']),
                        'parent_id' => $UserData->id,
                    ]);
                }
            }
            
            return $user;
        } else {
            return redirect()->back()->with('error', 'Api error.');
        }
    }

    public function validateEmail(Request $request)
    {
        $email = $request->input('email');
        $isExists = User::where('email',$email)->first();
        if($isExists){
            return response()->json(array("exists" => true));
        }else{
            return response()->json(array("exists" => false));
        }
    }

    public function validateName(Request $request)
    {
        $name = $request->input('name');
        $isExists = User::where('name',$name)->first();
        if($isExists){
            return response()->json(array("exists" => true));
        }else{
            return response()->json(array("exists" => false));
        }
    }

    public function validatePhone(Request $request)
    {
        $telp = $request->input('mobile_no');
        $isExists = User::where('telp',$telp)->first();
        if($isExists){
            return response()->json(array("exists" => true));
        }else{
            return response()->json(array("exists" => false));
        }
    }
    
    public function validatePassword(Request $request)
    {
        $password = $request->input('password');
        $isExists = strlen($password);
        if($isExists < 3){
            return response()->json(array("exists" => true));
        }else{
            return response()->json(array("exists" => false));
        }
    }
    
    public function tidakSama(Request $request)
    {
        $password = $request->input('password');
        $password_confirmation = $request->input('password_confirmation');
        if($password !== $password_confirmation){
            return response()->json(array("exists" => true));
        }else{
            return response()->json(array("exists" => false));
        }
    }

}
