<?php

namespace App\Http\Controllers;

use App\Http\Api\bgx;
use App\Http\Api\wokakse;
use App\Http\Api\fiver;
use App\Http\Api\sgx;
use App\Models\Game;
use App\Http\Api\softgaming;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\BgxGame;
use App\Models\BgxProvider;
use App\Models\GamingsoftGame;
use App\Models\NgGames;
use App\Models\NgProvider;
use App\Models\SgGame;
use App\Models\SgProvider;
use App\Models\SgxGames;
use App\Models\SgxProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GameController extends Controller
{
    public function slot(Request $request)
    {
        $segment = $request->segment(1);
        $type = 'SL';

        if ($segment == 'user/sports') {
            $type = 'SB';
        } elseif ($segment == 'casino') {
            $type = 'LC';
        } elseif ($segment == 'slot') {
            $type = 'slot';
        }

        $providers = BgxProvider::where('provider_type', $type)->get();
        return view('slots.provider', compact('providers'));
    }

    public function sports()
    {
        $providers = Game::where('provider_type', 'SB')->get();
        return $providers;
    }

    public function games()
    {
        $games = SgGame::all();
        return view('admin.games.index', compact('games'));
    }

    public function providers()
    {
        $sgProvider = BgxProvider::all();
        return view('admin.games.provider', compact('sgProvider'));
    }

    public function otherProvider()
    {
        $providers = BgxProvider::all();
        return view('admin.games.otprovider', compact('providers'));
    }

    public function serverB($provider_code, $provider_type)
    {
        $game = DB::table('fiver_games')
              ->where('game_provider', $provider_code)
              ->where('game_category', $provider_type)
              ->get();
        $providers = BgxProvider::where('provider_status', 1)->get();
        return view('slots.server-b', compact('game', 'providers'));
    }

public function connect_games(Request $request)
{
    try {
        $providerCode = strtoupper($request->game_provider);
        $gameCode = $request->game_code;
        
        

        // Get the game data from the database
        $game = DB::table('games')->where('game_provider', $providerCode)->where('game_code', $gameCode)->first();

        // If the game does not exist, log and redirect with error
        if (!$game) {
            \Log::warning('Game not found for code: ' . $gameCode);
            return redirect('/Slot')->with('error', 'Game tidak ditemukan.');
        }
        
        if ($game->whitelabel == 'NEXUSGGR') {
            $NX = new fiver();
            // CHECK providers
            if ($game->game_provider == 'PR') {
                $newProvider = 'PRAGMATIC';
            } else if ($game->game_provider == 'PG') {
                $newProvider = 'PGSOFT';
            } else if ($game->game_provider == 'PRL') {
                $newProvider = 'PRAGMATICLIVE';
            } else if ($game->game_provider == 'EP') {
                $newProvider = 'EVOPLAY';
            } else if ($game->game_provider == 'PG') {
                $newProvider = 'TOPTREND';
            } else if ($game->game_provider == 'PL') {
                $newProvider = 'PLAYSON';
            } else if ($game->game_provider == 'DT') {
                $newProvider = 'DREAMTECH';
            } else if ($game->game_provider == 'PG') {
                $newProvider = 'REELKINGDOM';
            } else if ($game->game_provider == 'CQ9') {
                $newProvider = 'CQ9';
            } else if ($game->game_provider == 'HB') {
                $newProvider = 'HABANERO';
            } else if ($game->game_provider == 'BG') {
                $newProvider = 'BOOONGO';
            } else {
                $newProvider = $game->game_provider;
            }
            
            $act = json_decode($NX->opengame(Auth::user()->name, $newProvider, $game->game_code));
            if (isset($act->status) && $act->status == 1) {
                return redirect()->away($act->launch_url);
            } else {
                //print_r($act);
                // Catch any unexpected errors and log them
                \Log::error('Unexpected error in connect_games', ['error' => $e->getMessage()]);
                return redirect('/slots')->with('error', $act->msg);
            }

            // Call the Fiver API to open the game
            
        }
        
    } catch (\Exception $e) {
        // Catch any unexpected errors and log them
        \Log::error('Unexpected error in connect_games', ['error' => $e->getMessage()]);
        return redirect('/slots')->with('error', 'Terjadi kesalahan pada sistem.');
        
    }
}




  
   public function connect_games2($id)
{
    try {
        // Initialize the Fiver API and get user balance
        $NX = new fiver();
        $saldo = json_decode($NX->userbalance(Auth::user()->name), true);
        
        // Default balance is 0 if not available
        $amount = isset($saldo['user']['balance']) ? $saldo['user']['balance'] : 0;

        // Initialize the BGX API for deposit and withdrawal
        //$SG = new bgx();

        // If balance > 0, perform deposit and withdrawal operations
        //if ($amount > 0) {
            //$SG->deposit(Auth::user()->name, $amount);
        //    $NX->withdraw(Auth::user()->name, $amount);
        //}

        // Get the game data from the BGX game table
        $game = DB::table('fiver_games')->where('game_code', $id)->first();

        // Check if game exists
        if (!$game) {
            return redirect('/casino')->with('error', 'Game tidak ditemukan.');
        }

        // Ensure the game status is 'active' (if the status is available)
        if ($game->status !== '1') {
            return redirect('/casino')->with('error', 'Game tidak aktif atau status tidak sesuai.');
        }
        
        if($game->game_provider == 'PR') {
            $new = 'PRAGMATICLIVE';
        } else if ($game->game_provider == 'EZ') {
            $new = 'EZUGI';
        } else {
            $new = 'EVOLUTION';
        }

        // Call the BGX API to open the game
        $response = $NX->opengame(Auth::user()->name, $game->game_code, 'PR');

        // Debugging: Check if response is empty or invalid
        if (!$response) {
            return redirect('/casino')->with('error', 'Maaf, terjadi kesalahan saat mengambil data game. Respons kosong.');
        }

        // Decode the response from JSON
        $act = json_decode($response);

        // Check if JSON decoding was successful
        if (is_null($act)) {
            return redirect('/casino')->with('error', 'Terjadi kesalahan pada data yang diterima. Response: ' . $response);
        }

        // Ensure that the 'status' field exists in the response
        if (!isset($act->status)) {
            return redirect('/casino')->with('error', 'Status tidak ditemukan dalam respons.');
        }

        // Check if the status is 1 to proceed with the game
        if ($act->status == 1) {
            return redirect()->away($act->launch_url); // Redirect to the game URL
        } else {
            return redirect('/casino')->with('error', 'Maaf Terjadi Kesalahan');
        }
    } catch (\Exception $e) {
        // Log unexpected errors
        \Log::error('Unexpected error in connect_games2', ['error' => $e->getMessage()]);
        return redirect('/Slot')->with('error', 'Terjadi kesalahan pada sistem.');
    }
}




    public function handleProvider($server, $game)
    {
        if ($server === 'server-a') {
            $NX = new fiver();
            $game = DB::table('fiver_games')->where('game_code', $game)->first();

            if (!$game) {
                return redirect('/Slot')->with('error', 'Game tidak ditemukan.');
            }

            $act = json_decode($NX->opengame(Auth::user()->name, $game->game_code, $game->game_provider));

            if ($act->status == 1) {
                return redirect()->away($act->launch_url);
            } else {
                return redirect('/Slot')->with('error', 'Maaf Terjadi Kesalahan');
            }
        } elseif ($server === 'server-b') {
            $SG = new fiver();
            $game = DB::table('fiver_games')->where('game_code', $game)->first();

            if (!$game) {
                return redirect('/Casino')->with('error', 'Game tidak ditemukan.');
            }

            $act = json_decode(Auth::user()->name, $game->game_code, $game->game_provider);

            if ($act->status == 1) {
                return redirect()->away($act->game_launch);
            } else {
                return redirect('/Casino')->with('error', 'Maaf Terjadi Kesalahan');
            }
        }
    }

    public function slotShow(Request $request)
    {
        $provider = $request->provider_code;
        $type = $request->provider_type;
        $game = SgGame::where('game_provider', $provider)->where('game_type', $type)->get();
        $providers = SgProvider::where('provider_status', 1)->where('provider_type', $type)->get();

        $manualTopGames = [
            'Gates of Olympus Xmas 1000',
            'Gates of Olympus 1000',
            'Mahjong Wins 3 - Black Scatter',
            'Starlight Christmas',
            'Starlight Princess 1000',
            'Sugar Rush Xmas',
            'Sweet Bonanza Xmas',
            'Penguins Christmas Party Time',
            'Gates of Olympus',
            'Sweet Bonanza 1000',
            'Starlight Princess',
            '5 Lions Megaways',
            'Mahjong Wins',
            'Mahjong Ways',
            'Mahjong Ways 2',
            'Lucky Neko',
            'Treasures of Aztec',
            'Wild Bandito',
            'Wild Bounty Showdown',
        ];

        $topGames = $game->filter(function ($game) use ($manualTopGames) {
            return in_array($game->game_name, $manualTopGames);
        });

        $topGames = $topGames->sortBy(function ($game) use ($manualTopGames) {
            return array_search($game->game_name, $manualTopGames);
        });

        $otherGames = $game->diff($topGames);
        $sortedGames = $topGames->merge($otherGames);

        return view('slots.games', compact('sortedGames', 'providers'));
    }

    public function deleteProviders($id)
    {
        $provider = SgProvider::find($id);
        if ($provider) {
            $provider->delete();
        }
        return redirect()->back()->with('success', 'Provider berhasil dihapus');
    }

    public function updateProviders(Request $request, string $id)
    {
        $request->validate([
            'provider_code' => 'required|string|max:255',
            'provider_name' => 'required|string|max:255',
            'provider_type' => 'required|string|max:255',
            'provider_status' => 'required|integer',
            'image_qr' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ]);

        $provider = SgProvider::find($id);
        if (!$provider) {
            return redirect()->back()->with('error', 'Provider tidak ditemukan.');
        }

        $provider->update($request->all());
        return redirect()->back()->with('success', 'Provider berhasil diupdate.');
    }

    public function updateOtherProviders(Request $request, string $id)
    {
        $request->validate([
            'provider_code' => 'required|string|max:255',
            'provider_name' => 'required|string|max:255',
            'provider_type' => 'required|string|max:255',
            'provider_status' => 'required|integer',
            'image_qr' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ]);

        $provider = NgProvider::find($id);
        if (!$provider) {
            return redirect()->back()->with('error', 'Provider tidak ditemukan.');
        }

        $provider->update($request->all());
        return redirect()->back()->with('success', 'Provider berhasil diupdate.');
    }
}
