<?php

namespace App\Http\Controllers;

use App\Http\Api\bgx;
use App\Http\Api\fiver;
use App\Http\Api\softgaming;
use App\Models\Saldo;
use App\Models\User;
use Illuminate\Http\Request;

class GetSaldoController extends Controller
{
    public function saldo(){
        $users = User::all();

        $saldoAPI = new fiver();
        $SG = new bgx();
        
        foreach ($users as $user) {
    try {
        // Get the user name from the user object
        $extplayer = $user->name;

        // Get balance from BGX API
        $act2 = json_decode($SG->userbalance($extplayer));

        // Ensure you handle the balance correctly, as it’s nested inside user->0->balance
        $bgxBalance = isset($act2->user[0]->balance) ? $act2->user[0]->balance : 0;

        // Get balance from Fiver API
        $act = json_decode($saldoAPI->userbalance($extplayer));

        // Check if the balance response from Fiver API is valid
        if ($act && $act->status == 1) {
            // Find the user's existing balance record in the database
            $userSaldo = Saldo::where('user_name', $act->user->user_code)->first();

            // If the user balance exists in the database, update it
            if ($userSaldo) {
                // Combine the balances if needed (e.g., add BGX balance to Fiver balance)
                $combinedBalance = $bgxBalance + $act->user->balance;  // Modify this as needed

                // Update the balance in the database
                $userSaldo->saldo = $combinedBalance;
                $userSaldo->save();
            } else {
                // Optionally, handle the case where the user's balance does not exist in the database
                \Log::warning('User saldo not found in database for user: ' . $act->user->user_code);
            }
        } else {
            // Handle the case where the balance API response is invalid
            \Log::error('Error fetching balance for user: ' . $extplayer . ' from saldoAPI');
        }

        // You can add additional checks or actions here if needed for $act2 (BGX API balance)

    } catch (\Exception $e) {
        // Log any unexpected errors that occur in the loop
        \Log::error('Error processing user: ' . $user->name, ['error' => $e->getMessage()]);
    }

        }
        
        return "Proses update saldo selesai.";
    }
}
