<?php

namespace App\Http\Controllers;

use App\Http\Api\bgx;
use App\Http\Api\fiver;
use App\Models\Banner;
use App\Models\Setting;
use App\Http\Api\gamingsoft;
use App\Models\Saldo;
use App\Models\SgGame;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    
    public function index()
    {
        $setting = Setting::first();
        $banners = Banner::all();
        $games = SgGame::paginate(20);
        return view('welcome', compact('setting', 'banners', 'games'  ));
    }

    public function activateRefferal()
    {
        return view('refferal.activate');
    }

   public function saldoRefresh()
{
    try {
        $userId = Auth::id();
        $saldo = Saldo::where('user_id', $userId)->first();
            
        if ($saldo) {
            $saldo->saldo = $saldo->saldo;
            $saldo->save();
        }
    } catch (\Exception $e) {
        // Catch and log errors
        \Log::error('Unexpected error in saldoRefresh', ['error' => $e->getMessage()]);
    }
}



    public function gs(Request $request)
    {
        $gs = new gamingsoft();
        $gs = json_decode($gs->createMember($request->username));
        return $gs;
    }

    public function launcGameReq(Request $request)
    {
        $username = $request->username;
        $password = $request->password;
        $providerCode = $request->providerCode;
        $type = $request->type;
        $gameid = $request->gameID;
        $lang = $request->lang;
        $html5 = $request->html5;
        $blimit = $request->blimit;

        $gs = new gamingsoft();
        $gs = json_decode($gs->launchGame($username, $password, $providerCode, $type, $gameid, $lang, $html5, $blimit), true);

        return $gs;
    }
}
