<?php

namespace App\Http\Controllers;

use App\Http\Api\fiver;
use App\Http\Api\softgaming;
use App\Models\User;
use App\Models\Saldo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class InjectController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = User::where('id', '!=', 1)->get();
        return view('admin.data_member.inject', compact('user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $user = User::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255',
            'saldo' => 'required|numeric',
            'action' => 'required|in:deposit,withdraw',
            'deposit' => 'nullable|numeric',
            'withdraw' => 'nullable|numeric',
        ]);

        $saldo = intval($request->input('saldo'));

        if ($request->input('action') == 'deposit') {
                $saldo_user = Saldo::where('user_id', $user->id)->first();
                $saldo = $request->input('saldo');
                $saldo_user->saldo = $saldo_user->saldo + $saldo;
                $saldo_user->save();
        } elseif ($request->input('action') == 'withdraw') {
                $saldo_user = Saldo::where('user_id', $user->id)->first();
                $saldo = $request->input('saldo');
                $saldo_user->saldo = $saldo_user->saldo - $saldo;
                $saldo_user->save();
        } else {
            return redirect()->back()->with('error', 'GAGAL');
        }

        return redirect()->back()->with('success', 'GAGAL');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
