<?php

namespace App\Http\Controllers;

use App\Models\Bank;
use App\Models\Network;
use App\Models\ReferralData;
use App\Models\Saldo;
use App\Models\Transaksi;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class KycConctroller extends Controller
{
    public function index()
    {
        return view('admin.kyc.index');
    }

    public function listReff()
    {
        $data_member = ReferralData::where('id', '!=', 1)
            ->orderBy('created_at', 'desc')
            ->get();

        if (request()->ajax()) {
            return DataTables::of($data_member)
                ->addIndexColumn()
                ->addColumn('name', function ($row) {
                    $user = User::where('email', $row->email)->first(); 
                    return $user ? $user->name : 'Tidak ditemukan';
                })
                ->addColumn('action', function ($row) {
                    $user = User::where('email', $row->email)->first();

                    if ($user) {
                        if ($user->email_verified_at) {
                            if ($user->status_reff == 0) {
                                return '
                                    <form action="' . route('on.reff', ['id' => $user->id]) . '" method="POST">
                                        ' . csrf_field() . '
                                        <input type="hidden" name="reff_status" value="1">
                                        <button type="submit" class="btn btn-primary btn-block">Confirm</button>
                                    </form>
                                ';
                            } else {
                                return '
                                    <form action="' . route('off.reff', ['id' => $user->id]) . '" method="POST">
                                        ' . csrf_field() . '
                                        <input type="hidden" name="reff_status" value="0">
                                        <button type="submit" class="btn btn-warning btn-block">Block</button>
                                    </form>
                                ';
                            }
                        } else {
                            return '<span class="text-muted">Email belum diverifikasi</span>';
                        }
                    }

                    return '<span class="text-danger">User tidak ditemukan</span>';
                })
                ->addColumn('user_identification', function ($row) {
                    if ($row->user_identification) {
                        $filePath = asset('storage/' . $row->user_identification);
                        return '<a href="' . $filePath . '" target="_blank">Lihat Disini</a>';
                    } else {
                        return 'Tidak ada bukti';
                    }
                })
                ->rawColumns(['action', 'user_identification'])
                ->make(true);
        }

        return view('admin.kyc.index', compact(['data_member']));
    }


    public function reffShow(String $id)
    {
        $email = ReferralData::where('id', $id)->value('email'); 
        $user = User::where('email', $email)->first();
        $reff = Network::where('parent_id', $id)->get('username');
        $downlines = User::whereIn('name', $reff)->orderBy('created_at', 'asc')->get();
        $usernames = $downlines->pluck('name');
        $saldo = Saldo::whereIn('user_name', $usernames)->get();
        $total = $saldo->sum('saldo');
        $totalDownline = $downlines->count();

        $deposits = [];
        $totalFirstDeposit = 0;
        foreach ($downlines as $downline) {
            $firstDeposit = Transaksi::where('user_name', $downline->name)
                ->where('status', 2) 
                ->orderBy('created_at', 'asc')
                ->first();
            $deposits[$downline->name] = $firstDeposit ? $firstDeposit->nominal : 0;
            $totalFirstDeposit += $deposits[$downline->name];
        }

        return view('admin.kyc.reffData', compact('user', 'downlines', 'totalDownline', 'total', 'saldo', 'deposits', 'totalFirstDeposit'));
    }

}
