<?php

namespace App\Http\Controllers;

use App\Mail\OtpMail;
use App\Models\ReferralData;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class OtpController extends Controller
{
    public function verifyOtp(Request $request)
    {
        $user = User::where('email', $request->email)->where('otp', $request->otp)->first();

        if (!$user) {
            return response()->json(['status' => 'error', 'message' => 'Invalid OTP or email.'], 400);
        }
        if (now()->greaterThan($user->otp_expiration)) {
            return response()->json(['status' => 'error', 'message' => 'OTP has expired.'], 400);
        }

        $user->otp = null;
        $user->otp_expiration = null;
        $user->save();

        return response()->json(['status' => 'success', 'message' => 'OTP verified successfully.']);
    }

    public function resendOtp(Request $request)
    {
        try {
            $user = User::where('email', $request->email)->first();

            if (!$user) {
                return response()->json(['message' => 'User not found.'], 404);
            }

            $otp = mt_rand(100000, 999999);
            $user->otp = $otp;
            $user->otp_expiration = Carbon::now()->addMinutes(10);
            $user->save();

            // Mengirim email OTP
            Mail::to($request->email)->send(new OtpMail($otp));

            return response()->json(['message' => 'OTP has been resent.'], 200);
            
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'An error occurred.',
                'error' => $e->getMessage(),
                'trace' => $e->getTrace() 
            ], 500);
        }
    }


    public function storeRefferal(Request $request)
    {

        $filePath = null;
        if ($request->hasFile('user_identification')) {
            $filePath = $request->file('user_identification')->store('public/user_identifications');
        }

        // Simpan data ke tabel referral_data
        ReferralData::create([
            'email' => $request->email,
            'otp' => $request->otp,
            'bank_name' => $request->bank_name,
            'name' => $request->name,
            'user_identification' => $filePath, 
        ]);
        
        $user = User::where('email', $request->email)->first();
        $user->email_verified_at = Carbon::now();
        $user->save();


        return redirect('/activate-refferal');

    }
}
