<?php

namespace App\Http\Controllers;

use App\Http\Api\fiver;
use App\Http\Api\Notification;
use App\Models\Network;
use App\Models\Saldo;
use App\Models\Setting;
use App\Models\Transaksi;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PaymentGatewayController extends Controller
{
    public function create(Request $request)
    {
        $setting = Setting::first();
        if ($request->nominal < $setting->minimal_depo) {
            return redirect()->back()->with('error', 'Minimal deposit adalah Rp '. number_format($setting->minimal_depo, 0, ',', '.'));
        }

        $delay_deposit = empty($setting->deposit_delay) ? 24 : $setting->deposit_delay;

            $trans = Transaksi::where([
                'user_id' => Auth::user()->id,
                'status' => 1
            ])->first();



            if (!empty($trans)) {
                $hours_delay = floor(abs(strtotime($trans->created_at) - strtotime(date('Y-m-d H:i:s'))) / 3600);

                if ($hours_delay < $delay_deposit) {
                    return redirect()->back()->with('error', 'Transaksi sebelumnya sedang di proses, mohon menunggu admin untuk approval');
                }

                $trans->status = 3;
                $trans->save();
            }
        $key = $setting->apikey_gateway;
        $nominal = $request->input('nominal');
        session(['nominal' => $nominal]);
        $unique_code = getTrx();
        session(['unique_code' => $unique_code]);
        $services = 23;

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $setting->url_gateway);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        $post = array(
            'key' => $key,
            'request' => 'new',
            'unique_code' => $unique_code,
            'service' => $services,
            'amount' => $nominal,
            'note' => 'Pembayaran pertama',
            'valid_time' => '300',
            'type_fee' => '0',
            'payment_guide' => TRUE,
            'signature' => md5($key . $unique_code . $services . $nominal . '300' . 'NewTransaction'),
            'return_url' => $setting->callback_url
        );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
        $responseData = json_decode($result, true);
        $status = $responseData['success'];
        $qris = $responseData['data']['qrcode_url'];
        $statusReq = 'new';
        $encodedUrl = base64_encode($qris);

        if ($qris) {
            $transaksi = new Transaksi();
            $transaksi->type = $request->type;
            $transaksi->status = $request->status;
            $transaksi->trans_id = $unique_code;
            $transaksi->bonus_id = $request->bonus_id;
            $transaksi->bonus_persentase = $request->bonus_persentase;
            $transaksi->nominal = str_replace(',', '', $request->nominal);
            $transaksi->bank_id = $request->bank_id;
            $transaksi->rek_pengirim = Auth()->user()->bank . ' - ' . Auth()->user()->no_rek;
            $transaksi->keterangan = $request->keterangan;
            $transaksi->user_id = Auth::user()->id;
            $transaksi->user_name = Auth::user()->name;
            $transaksi->qris_url = $qris;

            if ($request->hasFile('bukti_transfer')) {
                $transaksi->bukti_transfer = $request->file('bukti_transfer')->store('post-images');
            }

            $User = Network::where('user_id', Auth()->User()->id)->first();
            if (isset($User)) {
                $transaksi->ref = $User->ref_code;
            } else {
                $transaksi->ref = Null;
            }

            $transaksi->save();
            $phone = Auth::user()->telp;
            $nominal = $request->nominal;
            $notification = new Notification();
            $send = $notification->depositQris($phone, $nominal, $qris);
        }

        return view('content.payment', compact('encodedUrl', 'nominal', 'setting', 'statusReq'));
    }

    public function statusPayment(Request $request)
    {
        $user = auth()->user();
        $transaksi = Transaksi::where('user_id', $user->id)->latest()->first();
        $invoice_code = $transaksi->trans_id;
        $setting = Setting::first();
        $key = $setting->apikey_gateway;
        $unique_code = session('unique_code');
        $sign = md5($key.$unique_code.'StatusTransaction');
        $ch = curl_init();
                                                                            
        curl_setopt($ch, CURLOPT_URL, $setting->url_gateway);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        $post = array(
            'key' => $key,
            'request' => 'status',
            'unique_code' => $invoice_code,
            'signature' => $sign
        );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
                                                                                    
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
        $responseData = json_decode($result, true);
        $status = $responseData['data']['status'];
        
        if ($status == 'Success') {
            $trans_id = $responseData['data']['unique_code'];
            $amount = intval($responseData['data']['amount']);
            $transaksi = Transaksi::where('trans_id',$trans_id)->first();
            $user = User::where('id', $transaksi->user_id)->first();
            $SG = new fiver();
            $act = json_decode($SG->deposit($user->name, $amount));

            if ($act->msg == 'SUCCESS') {
                $SG = new fiver();
                $act = json_decode($SG->userbalance($user->name));
                $saldo = Saldo::where('user_id', $transaksi->user_id)->first();
                
                $saldo->saldo = $act->user->balance;
                $saldo->bonus = $amount;
                $saldo->save();

                $transaksi = Transaksi::where('trans_id',$trans_id)->first();
                $transaksi->status = 2;
                $transaksi->alasan = 'Transaksi menggunakan QRIS Otomatis';
                $transaksi->approved_at = date('Y-m-d H:i:s');
                $transaksi->approved_by = 'Otomatis';
                $transaksi->save();
                
                return redirect('/account/lastDirectTransfer')->with('success', 'Transaksi telah dibayar');
            }
        }else {
            return redirect('/account/lastDirectTransfer')->with('error', 'Transaksi belum dibayar');
        }
    }

    public function paymentQris()
    {
        $user = auth()->user();
        $transaksi = Transaksi::where('user_id', $user->id)->latest()->first();
        $setting = Setting::first();
        
        // Cek apakah transaksi ada
        if ($transaksi) {
            $nominal = $transaksi->nominal;
            $payQRIS = $transaksi->qris_url;

            // Cek jika transaksi lebih dari 5 menit
            $createdAt = $transaksi->created_at;
            $currentTime = Carbon::now();

            // Inisialisasi notifikasi
            $notification = null;

            if ($currentTime->diffInMinutes($createdAt) > 5) {
                // Jika sudah lebih dari 5 menit, kirim notifikasi
                return redirect()->back()->with('error', 'Transaksi sudah lewat 5 menit');
            }

            $statusReq = 'repeat';
        } else {
            $nominal = 0;
            $payQRIS = null;
            $statusReq = 'no_transaction';
            $notification = 'Tidak ada transaksi ditemukan.';
        }
        return view('content.payment', compact('setting','payQRIS', 'nominal', 'statusReq'));
    }
}