<?php 
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Trans; // Sesuaikan dengan nama model Anda
use App\Models\Saldo; // Import model Saldo
use App\Http\Api\fiver;

class QrisCallbackController extends Controller
{
    public function handle(Request $request)
    {
        \Log::info('Callback Data:', $request->all());

        $data = $request->all();

        $validated = $request->validate([
            'terminal_id' => 'required|string|exists:users,name',
            'trx_id' => 'required|string',
            'amount' => 'required|numeric|min:0.01',
            'custom_ref' => 'nullable|string',
            'created_at' => 'required|date',
            'status' => 'required|string',
        ]);

        $parentUser = User::where('name', $data['terminal_id'])->first();

        if (!$parentUser) {
            return response()->json(['success' => false, 'message' => 'User not found'], 404);
        }

        try {
            DB::beginTransaction();

            \Log::info('Starting Transaction');

            $note = 'Topup QRIS Otomatis';
            $kd_transaksi = 'QRIS' . $data['trx_id'];
            $created_date = now();

            // Simpan transaksi ke tabel `transaksi`
            $transaksi = new Trans();
            $transaksi->ref = $data['custom_ref'];
            $transaksi->type = 1; // 1 untuk Deposit
            $transaksi->status = $data['status'] === 'success' ? 2 : 0; // 2 Approved, 0 Pending
            $transaksi->trans_id = $data['trx_id'];
            $transaksi->bonus_id = null;
            $transaksi->bonus_persentase = null;
            $transaksi->nominal = $data['amount'];
            $transaksi->user_id = $parentUser->id;
            $transaksi->user_name = $parentUser->name;
            $transaksi->created_at = $created_date;
            $transaksi->updated_at = $created_date;
            $transaksi->approved_at = $created_date;
            $transaksi->approved_by = 'BY QRIS SERVER';
            $transaksi->bukti_transfer = 'OTOMATIS';
            $transaksi->bank_id = 99;
            $transaksi->bank_tujuan = 'QRIS';
            $transaksi->rek_pengirim = $parentUser->bank_tujuan ?? 'Unknown';
            $transaksi->keterangan = $note;
            $transaksi->alasan = null;
            $transaksi->qris_url = null;
            \Log::info('Before Saving Transaksi:', $transaksi->toArray());
            $transaksi->save();
            \Log::info('After Saving Transaksi');

            // Update saldo di tabel `saldo` berdasarkan user_name
            $saldo = Saldo::where('user_name', $parentUser->name)->first();

            if (!$saldo) {
                $saldo = new Saldo();
                $saldo->user_name = $parentUser->name;
                $saldo->saldo = $data['amount']; // Set nominal awal
            } else {
                $saldo->saldo += $data['amount'];
            }
            \Log::info('Before Saving Saldo:', $saldo->toArray());
            $saldo->save();

            // Opsional: Panggil API untuk deposit
            $controller = new fiver();
            $response = $controller->deposit($data['terminal_id'], (int)$data['amount']);

            DB::commit();
            return response()->json(['message' => 'Success Process by System']);
        } catch (\Exception $e) {
            DB::rollBack();
            \Log::error('Transaction Failed:', [
                'error' => $e->getMessage(),
                'data' => $data
            ]);
            return response()->json(['success' => false, 'message' => 'Internal Server Error.'], 500);
        }
    }
}
