<?php

namespace App\Http\Controllers;

use App\Models\BgxProvider;
use App\Models\GamingsoftGame;
use App\Models\GamingsoftProvider;
use App\Models\NgProvider;
use App\Models\SgProvider;
use App\Models\SgxProvider;
use Illuminate\Http\Request;

class SgGameController extends Controller
{
    public function hot(Request $request)
    {
        $type = 'Hpt Games';
        $providers = SgProvider::orderBy('id', 'asc')->skip(0)->take(10)->get();
        return view('slots.other', compact('providers', 'type'));
    }
    
    public function slot(Request $request)
    {
        $type = 'Slots';
        $providers = SgProvider::where('provider_type', 'SL')->where('provider_status', 1)->get();
        return view('slots.other', compact('providers', 'type'));
    }

    public function sports(Request $request)
    {
        $type = 'Sports';
        $providers = SgProvider::where('provider_type', 'SB')->where('provider_status', 1)->get();
        // return $providers;
        return view('slots.other', compact('providers', 'type'));   
    }

    public function casino(Request $request)
    {
        $type = 'Casino';
        $providers = SgProvider::where('provider_type', 'LC')->where('provider_status', 1)->get();
        // return $providers;
        return view('slots.other', compact('providers', 'type'));   
    }

    public function p2p(Request $request)
    {
        $type = 'Poker';
        $providers = SgProvider::where('provider_type', 'PK')->where('provider_status', 1)->get();
        return view('slots.other', compact('providers', 'type'));   
    }

    public function fishing(Request $request)
    {
        $type = 'Fishing';
        $providers = SgProvider::where('provider_type', 'FH')->where('provider_status', 1)->get();
        return view('slots.other', compact('providers', 'type'));   
    }
    
    public function lottery(Request $request)
    {
        $type = 'Lottery';
        $providers = SgProvider::where('provider_type', 'LK')->where('provider_status', 1)->get();
        return view('slots.other', compact('providers', 'type'));   
    }
    

    public function cockfight(Request $request)
    {
        $type = 'Other';
        $providers = SgProvider::where('provider_type', 'OT')->where('provider_status', 1)->get();
        return view('slots.other', compact('providers', 'type'));   
    }
}
