<?php

namespace App\Http\Controllers;

use App\Http\Api\fiver;
use App\Events\NewDepositEvent;
use App\Http\Api\Notification;
use App\Models\Bank;
use App\Models\User;
use App\Models\Bonus;
use App\Models\Saldo;
use App\Models\Setting;
use App\Models\Transaksi;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

use App\Http\Api\softgaming;
use App\Models\Network;

class UserDepositController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $saldo = Saldo::where('user_id', Auth()->user()->id)->first();
        $saldos = $saldo->saldo;

        $bonus = Bonus::where('status', 1)->get();
        $bank  = Bank::where('type', 1)->get();
        $ewallet  = Bank::where('type', 2)->get();
        $qris = Bank::where('type', 3)->get();
        $extplayer = User::where('name', Auth()->user()->name);
        $data = ["username" => Auth()->user()->name];
        $jsonString = json_encode($data);
        $base64Encoded = base64_encode($jsonString);
      
        $setting = Setting::first();
        return view('account.deposit', compact('saldos', 'bonus', 'bank', 'ewallet', 'qris', 'setting', 'extplayer', 'base64Encoded'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $setting = Setting::first();
        if ($request->nominal < $setting->minimal_depo) {
            return redirect()->back()->with('error', 'Minimal deposit adalah Rp ' . number_format($setting->minimal_depo, 0, ',', '.'));
        }
        $setting = Setting::first();
        $delay_deposit = empty($setting->deposit_delay) ? 24 : $setting->deposit_delay;

        $trans = Transaksi::where([
            'user_id' => Auth::user()->id,
            'status' => 1
        ])->first();
      
        

        if (!empty($trans)) {
            $hours_delay = floor(abs(strtotime($trans->created_at) - strtotime(date('Y-m-d H:i:s'))) / 3600);

            if ($hours_delay < $delay_deposit) {
                return redirect()->back()->with('error', 'Transaksi sebelumnya sedang di proses, mohon menunggu admin untuk approval');
            }

            $trans->status = 3;
            $trans->save();
        }
      
      
      	$bonusPersentase = Bonus::where('id', $request->bonus_id)->first();
        if ($bonusPersentase && $bonusPersentase->is_one_time && Auth::user()->first_deposit) {
            return redirect()->back()->with('error', 'Maaf, anda sudah pernah claim bonus ini.');
        }
        $bonuspersen = $bonusPersentase ? $bonusPersentase->nominal : 0;

        $transaksi = new Transaksi();
        $transaksi->type = $request->type;
        $transaksi->status = $request->status;
        $transaksi->trans_id = getTrx();
        $transaksi->bonus_id = $request->bonus_id;
        $transaksi->bonus_persentase = $bonuspersen;
        $transaksi->nominal = str_replace(',', '', $request->nominal);
        $transaksi->bank_id = $request->bank_id;
     	$transaksi->bank_tujuan = $request->rek_tujuan;
        $transaksi->rek_pengirim = Auth()->user()->bank . ' - ' . Auth()->user()->no_rek;
        $transaksi->keterangan = $request->keterangan;
        $transaksi->user_id = Auth::user()->id;
        $transaksi->user_name = Auth::user()->name;
      
        if ($request->hasFile('bukti_transfer')) {
            $transaksi->bukti_transfer = $request->file('bukti_transfer')->store('post-images');
        }

        session(['rek_tujuan' => $request->rek_tujuan]);
        session(['nominal' => $request->nominal]);

        $User = Network::where('user_id', Auth()->User()->id)->first();
        if (isset($User)) {
            $transaksi->ref = $User->ref_code;
        } else {
            $transaksi->ref = Null;
        }

        $transaksi->save();

        if ($transaksi->save()) {
            $fonte_status = Setting::value('fonte_status');
            if ($fonte_status == 1) {
                $this->sendMessage();
            }
            
            return back()->with('success', 'Deposit Manual berhasil silahkan hubungi admin.');
        } else {
            return back()->with('error', 'Transaksi gagal, silakan coba lagi.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }



    public function action(string $id, Request $request)
    {
        $transaksi = Transaksi::find($id);
        $User = User::where('id', $transaksi->user_id)->first();
        $amount = $transaksi->nominal;
        $bonus = $transaksi->nominal + $transaksi->nominal * $transaksi->bonus_persentase / 100;


        if ($request->status == 2) {
            $transaksi = Transaksi::find($id);
            $transaksi->approved_at = date('Y-m-d H:i:s');
            $transaksi->approved_by = auth()->user()->id;
        }

        DB::beginTransaction();

        $transaksi->save();


        if ($request->status == 2 && $transaksi->type == 1) {
            if ($transaksi->bonus_id) {
                $transaksi = Transaksi::find($id);
                $User = User::where('id', $transaksi->user_id)->first();
                    $transaksi = Transaksi::find($id);
                    $User = User::where('id', $transaksi->user_id)->first();
                    $saldo = Saldo::where('user_id', $transaksi->user_id)->first();

                    $saldo->saldo = $saldo->saldo + $bonus;
                    $saldo->bonus = $amount;
                    $saldo->save();

                    $transaksi = Transaksi::find($id);
                    $transaksi->status = $request->status;
                    $transaksi->alasan = NULL;
                    $transaksi->approved_at = date('Y-m-d H:i:s');
                    $transaksi->approved_by = auth()->user()->id;
                    $transaksi->save();
                //}
            } else {
                $transaksi = Transaksi::find($id);
                $User = User::where('id', $transaksi->user_id)->first();
                    $saldo = Saldo::where('user_id', $transaksi->user_id)->first();
                    // dd($act);

                    $saldo->saldo = $saldo->saldo + $amount;
                    $saldo->bonus = $amount;
                    $saldo->save();

                    $transaksi = Transaksi::find($id);
                    $transaksi->status = $request->status;
                    $transaksi->alasan = $request->alasan;
                    $transaksi->approved_at = date('Y-m-d H:i:s');
                    $transaksi->approved_by = auth()->user()->id;
                    $transaksi->save();
            }
        }


        if ($request->status == 3 && $transaksi->type == 1) {
            $transaksi = Transaksi::find($id);
            $transaksi->status = $request->status;
            $transaksi->alasan = $request->alasan;
            $transaksi->approved_at = date('Y-m-d H:i:s');
            $transaksi->approved_by = auth()->user()->id;
            $transaksi->save();
        }

        DB::commit();
        return redirect()->back()->with('success', 'Data changed successfully');
    }
  
  	public function checkDepositStatus()
    {
        $latestDeposit = Transaksi::where('status', 1)->latest()->first();

        if ($latestDeposit) {
            return response()->json([
                'newDeposit' => true,
                'nominal' => $latestDeposit->nominal,
                'user_id' => $latestDeposit->user_name, 
            ]);
        }

        return response()->json(['newDeposit' => false]);
    }

    public function sendMessage()
    {
        $curl = curl_init();

        $tokenData = Setting::get('fonte_token');
        $funteNumber = Setting::get('fonte_wa');

        $bankTujuan = session('rek_tujuan');
        $nominal = session('nominal');
        $message = 'New transaction: ' . 'Rp ' . number_format($nominal, 0, ',', '.') . ' to ' . $bankTujuan;

        $tokenArray = json_decode($tokenData, true);
        $token = $tokenArray[0]['fonte_token'] ?? null; 

        if (!$token) {
            return response()->json(['error' => 'Token not found'], 400);
        }

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.fonnte.com/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'target' => $funteNumber,
                'message' => $message,
            ],
            CURLOPT_HTTPHEADER => ['Authorization: ' . $token],
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }
}
