<?php

namespace App\Http\Controllers;

use App\Http\Api\fiver;
use App\Models\Saldo;
use App\Models\Transaksi;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Http\Api\wokakse;
use App\Models\Network;

class UserWithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $saldo = Saldo::where('user_id', Auth()->user()->id)->first();
        $saldos = $saldo->saldo;
        $rek = User::where('id', Auth::user()->id)->first();
        return view('account.withdraw', compact('saldos', 'rek'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        $transaksi = Transaksi::where('user_id', Auth()->user()->id)
            ->where('type', 2)
            ->where('status', 1)
            ->first();
        if ($transaksi) {
            return back()->with('info', 'Tunggu Withdraw Sebelumnya Diterima !');
        }
        $validatedData = $request->validate([
            'amount' => 'required',
        ]);

        $amount = intval($request->amount);
            $transaksi = new Transaksi();
            $transaksi->type = 2;
            $transaksi->status = 1;
            $transaksi->trans_id = getTrx();
            $transaksi->user_name = Auth()->user()->name;
            $transaksi->nominal = $request->amount;
            $transaksi->keterangan = Auth()->user()->bank . ' - ' . Auth()->user()->no_rek;
            $transaksi->rek_pengirim = $request->acc_no;
            $transaksi->user_id = Auth::user()->id;
            $saldo = Saldo::where('user_id', Auth()->user()->id)->first();
            $saldo->saldo = $saldo->saldo - $amount;
            $saldo->save();

            if (isset($User)) {
                $transaksi->ref = $User->ref_code;
            } else {
                $transaksi->ref = Null;
            }
            $transaksi->save();

        return redirect()->back()->with('success', 'Data berhasil disimpan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    public function aksi(string $id, Request $request)
    {
        $transaksi = Transaksi::find($id);
        $User = User::findOrFail($transaksi->user_id);

        if ($request->status == 3 && $transaksi->type == 2) {
                $saldo = Saldo::where('user_id', $transaksi->user_id)->first();

                $saldo->saldo = $saldo->saldo + $transaksi->nominal;
                $saldo->save();

                $transaksi->user_name = $User->name;
                $transaksi->status = $request->status;
                $transaksi->alasan = $request->alasan;
                $transaksi->approved_at = date('Y-m-d H:i:s');
                $transaksi->approved_by = auth()->user()->id;
                $transaksi->save();
        } else {

            $transaksi->status = $request->status;
            $transaksi->alasan = $request->alasan;
            $transaksi->approved_at = date('Y-m-d H:i:s');
            $transaksi->approved_by = auth()->user()->id;
            $transaksi->save();
        }

        return redirect()->back()->with('success', 'Data changed successfully');
    }

    public function WD()
    {
        // $amount = 110000;
        $SG = new fiver();
        $act =  json_decode($SG->resetBalance());
        return $act;
    }
}
