<?php

namespace App\Http\Controllers\backoffice;

use App\Http\Api\bgx;
use App\Http\Api\fiver;
use App\Http\Api\softgaming;
use App\Models\Transaksi;
use App\Models\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class BackofficeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // dashboard datas
        $trans = new Transaksi();
        $data['deposit'] = $trans->get_summary_transaksi();

        $member = new User();
        $data['member'] = $member->get_summary_member();


        return view('admin.backoffice', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function agentbalance()
    {
        $SG = new fiver();
        $act = json_decode($SG->agentbalance());
        $balance = $act->agent->balance;

        return response()->json(['balance' => $balance]);
    }
  public function agentbalance2()
{
 
    $SG = new bgx();
    $response = $SG->agentbalance();
    $act = json_decode($response, true);

    if (is_array($act) && isset($act['agent'][0]['balance'])) {
        $balance2 = $act['agent'][0]['balance']; 
    } else {
        $balance2 = 0;
        
        \Log::error('Agent balance API failed or returned unexpected response', ['response' => $act]);
    }

    // Return a consistent response
    return response()->json(['balance2' => $balance2]);
}



    public function getTotalBersihHarian()
    {
        // Mendapatkan tanggal hari ini
        $todayStart = Carbon::today()->startOfDay();
        $todayEnd = Carbon::today()->endOfDay();

        // Menghitung total deposit hari ini
        $totalDeposit = Transaksi::where('type', 1)
            ->where('status', 2)
            ->whereBetween('created_at', [$todayStart, $todayEnd])
            ->sum('nominal');


        $totalWithdraw = Transaksi::where('type', 2)
            ->where('status', 2)
            ->whereBetween('created_at', [$todayStart, $todayEnd])
            ->sum('nominal');

        $totalBersih = $totalDeposit - $totalWithdraw;

        return response()->json([
            'total_bersih' => $totalBersih,
        ]);
    }
}
