<?php

namespace App\Http\Controllers\backoffice;

use App\Http\Api\bgx;
use App\Http\Api\fiver;
use App\Http\Api\ngaming;
use App\Http\Api\sgx;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Bank;
use App\Models\Saldo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\URL;
use App\Http\Api\softgaming;
use App\Models\Network;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Transaksi;
use Yajra\DataTables\Facades\DataTables;

class DatamemberController extends Controller
{
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255', 'unique:users'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data_member = User::where('id', '!=', 1)
                    ->orderBy('created_at', 'desc')
                    ->get();
    
        if (request()->ajax()) {
            return DataTables::of($data_member)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    return '<a href="' . route('data_member.edit', $row->id) . '" class="btn btn-primary">Edit</a>';
                })
                ->addColumn('rek_details', function($row) {
                    return $row->bank . ' - ' . $row->no_rek;
                })
                ->make(true);
        }
        $data_bank = Bank::get();

        return view('admin.data_member.data_member', compact(['data_member', 'data_bank']));
    }

    public function create(Request $request)
    {
        $refferalcode = Str::random(6);
        $domain = URL::to('/');
        $Url = $domain . '/referral-register?ref=' . $refferalcode;
        $extplayer = $request['nama'];

        //Create Account to SGX
        $SGX = new bgx();
        $acts = $SGX->create($extplayer);

        $NX = new fiver();
        $act = json_decode($NX->create($extplayer));
        
        if ($act->status == 1) {
            $request->validate([
                'nama' => 'required|unique:users,name',
            ], [
                'nama.unique' => 'Nama sudah terdaftar.',
            ]);

            $user = User::create([
                'extplayer' => $extplayer,
                'name' => $request->input('nama'),
                'email' => $request->input('email'),
                'password' => Hash::make($request->input('password')),
                'telp' => $request->input('telp'),
                'ref_code' => $refferalcode,
                'ref_link' => $Url,
                'nama_rek' => $request->input('nama_rek'),
                'bank' => $request->input('bank'),
                'no_rek' => $request->input('no_rek'),
                'ip_register' => $request->input('ip_register'),
                'token' => Str::random(7),
            ]);
    
            if (isset($data['ref_code'])) {
                $UserData = User::where('ref_code', $data['ref_code'])->first();
                if ($UserData) {
                    Network::create([
                        'user_id' => $user->id,
                        'ref_code' => $data['ref_code'],
                        'username' => $data['name'],
                        'parent_id' => $UserData->id,
                    ]);
                }
            }

            $saldo = new Saldo();
            $saldo->user_id = $user->id;
            $saldo->user_name = $user->name;
            $saldo->saldo = 0;
            $saldo->bonus = 0;
            $saldo->save();
            
            return redirect('/data_member')->with('success', 'Akun berhasil ditambahkan');
        }else {
            return redirect('/data_member')->with('error', 'Terjadi kesalahan ('.$act->msg.')');
        }
    }

    public function show(string $id)
    {
        $user = User::find($id);
        $saldo = Saldo::where('user_id', $user->id);
        return response()->json([
            'saldo' => $saldo,
        ]);
    }

    public function update(Request $request, string $id)
    {

        $member = User::findOrFail($id);

      if ($request->filled('nama')) {
          $member->name = $request->nama;
      }

      if ($request->filled('password')) {
          $member->password = bcrypt($request->password);
      }

      if ($request->filled('email')) {
          $member->email = $request->email;
      }

      if ($request->filled('telp')) {
          $member->telp = $request->telp;
      }

      if ($request->filled('ref_code')) {
          $member->ref_code = $request->ref_code;
      }

      if ($request->filled('nama_rek')) {
          $member->nama_rek = $request->nama_rek;
      }

      if ($request->filled('bank')) {
          $member->bank = $request->bank;
      }

      if ($request->filled('no_rek')) {
          $member->no_rek = $request->no_rek;
      }

      $member->save();

      return redirect('downline/member/' . $request->id)->with('success', 'Data member berhasil diperbarui');

    }
  
    public function onReff(Request $request, string $id)
      {
          $member = User::findOrFail($id);
          $member->status_reff = 1;
          $member->save();

        //   return redirect('/data_member')->with('success', 'Refferal status aktif');
        return redirect()->back()->with('success', 'Refferal status aktif');

      }
      public function offReff(Request $request, string $id)
          {
              $member = User::findOrFail($id);
              $member->status_reff = 0;
              $member->save();

            //   return redirect('/data_member')->with('success', 'Refferal berhasil di konfirmasi');
              return redirect()->back()->with('error', 'Refferal Non-Active');

          }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $data = User::find($id);

        $data->delete();
        $msg = 'Member berhasil dihapus';

        return redirect('/data_member')->with('success', $msg);
        
    }

    public function downlineShow(String $id)
    {
        $user = User::find($id); 
        $reff = Network::where('parent_id', $id)->get('username');
        $downlines = User::whereIn('name', $reff)->orderBy('created_at', 'asc')->get(); 
        
        $refferal = Network::where('username', $user->name)->value('parent_id'); 
        $users = User::orderBy('name', 'asc')->get();
        
        $usernames = $downlines->pluck('name');
        $saldo = Saldo::whereIn('user_name', $usernames)->get(); 
        $total = $saldo->sum('saldo'); 
        $totalDownline = $downlines->count(); 

        $deposits = [];
        $totalFirstDeposit = 0;
        foreach ($downlines as $downline) {
            $firstDeposit = Transaksi::where('user_name', $downline->name)
                ->where('status', 2) 
                ->orderBy('created_at', 'asc')
                ->first();
            $deposits[$downline->name] = $firstDeposit ? $firstDeposit->nominal : 0;
            $totalFirstDeposit += $deposits[$downline->name];
        }
        
        
        
        $game_type = 'slot';
        $page = 0;
        $perPage = 1000;
        $targetValue = 1000000; // 1 juta
        $turnUser = User::where('name', $user->name)->first();

        $endDate = Carbon::now('Asia/Jakarta')->format('Y-m-d H:i:s');
        $startDate = $turnUser->created_at;
        

        $SG = new fiver();
        $response = $SG->historyPlay($turnUser->name, $game_type, $startDate, $endDate, $page, $perPage);

        $act = json_decode($response, true);

        if (isset($act['slot']) && is_array($act['slot'])) {
            $bet_money_values = array_map(function ($spin) {
                return $spin['bet_money'];
            }, $act['slot']);

            $spin = $act['total_count'];
            $turnover = array_sum($bet_money_values);

            // Get the latest entry
            $latest_entry = end($act['slot']);
            $latest_bet = $latest_entry['bet_money'] ?? 0;
            $latest_date = Carbon::now('Asia/Jakarta')->format('Y-m-d H:i:s');

            $progressive = ($turnover / $targetValue) * 100;
            if ($progressive > 100) {
                $progressive = 100;
            }
        } else {
            $spin = 0;
            $turnover = 0;
            $progressive = 0;
            $latest_bet = 0;
            $latest_date = null;
        }

        // Return response as JSON
        //return response()->json([
        //    'spin' => $spin,
        //    'turnover' => $turnover,
        //    'progressive' => $progressive,
        //    'latest_bet' => $latest_bet,
        //    'latest_date' => $latest_date,
        //]);

        return view('admin.data_member.downline_member', compact('user', 'downlines', 'totalDownline', 'total', 'saldo', 'deposits', 'totalFirstDeposit', 'refferal', 'users', 'spin', 'turnover', 'progressive', 'latest_bet', 'latest_date'));
    }
    

    public function updateReff(Request $request, String $id)
    {
        $request->validate([
            'parent_id' => 'required|exists:users,id',
        ]);

        $reffCode = User::where('id', $request->input('parent_id'))->value('ref_code');
        $downline = User::where('id', $id)->value('name');
        $network = Network::updateOrCreate(
            ['user_id' => $id],
            [
                'parent_id' => $request->input('parent_id'),
                'ref_code' => $reffCode,
                'username' => $downline,
            ]
        );

        // return $network;
        return redirect()->back()->with('success', 'Data referral berhasil diupdate atau dibuat');
    }
}
