<?php

namespace App\Http\Controllers\backoffice;

use App\Http\Api\fiver;
use App\Http\Api\Notification;
use App\Http\Api\softgaming;
use App\Http\Controllers\Controller;
use App\Models\Bonus;
use App\Models\Network;
use App\Models\Saldo;
use App\Models\Transaksi;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class DepositController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $transaksi = Transaksi::where('type', 1)->orderBy('created_at', 'desc')->get();

        $idBonuses = $transaksi->pluck('bonus_id')->unique();
        $bonuses = Bonus::whereIn('id', $idBonuses)->get();

        return view('admin.deposit.deposit', compact('transaksi', 'bonuses'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function reject(Request $request, string $id)
    {

        $transaksi = Transaksi::find($id);
        $transaksi->status = 3;
        $transaksi->alasan = 'Reject oleh Admin';
        $transaksi->approved_at = date('Y-m-d H:i:s');
        $transaksi->approved_by = auth()->user()->id;
        $transaksi->save();
        return redirect()->back()->with('error', 'Deposit berhasil ditolak');
    }

    public function confirm(string $id, Request $request)
    {
        DB::beginTransaction();

        try {
            $transaksi = Transaksi::findOrFail($id);
            $user = User::findOrFail($transaksi->user_id);
            $amount = $transaksi->nominal;
            $bonus = $amount + ($amount * $transaksi->bonus_persentase / 100);

            if ($request->status == 2) {
                $transaksi->approved_at = now();
                $transaksi->approved_by = auth()->user()->id;
            }

            $transaksi->save();

            //$NX = new fiver();
            //$depositAmount = $transaksi->bonus_id ? $bonus : $amount;

            //$depositResponse = json_decode($NX->deposit($user->name, $depositAmount));
            //if ($depositResponse->status !== 1) {
            //    throw new \Exception('Deposit failed');
            //}

            //$balanceResponse = json_decode($NX->userbalance($user->name));
            //if ($balanceResponse->status !== 1) {
            //    throw new \Exception('User balance retrieval failed');
            //}

            $saldo = Saldo::firstOrCreate(['user_id' => $user->id]);
            $saldo->saldo = $saldo->saldo + $amount;
            $saldo->bonus = $amount;
            $saldo->save();

            $transaksi->status = 2;
            $transaksi->alasan = $transaksi->bonus_id ? null : $request->alasan;
            $transaksi->save();

            if (!$user->first_deposit) {
                $user->first_deposit = now();
            }
            $user->last_deposit = now();
            $user->save();

            $parent_id = Network::where('user_id', $user->id)->value('parent_id');
            if ($parent_id) {
                $this->addReferralBonus($parent_id, $depositAmount);
            }

            DB::commit();

            return redirect()->back()->with('success', 'Deposit berhasil diproses');
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    private function addReferralBonus($parent_id, $amount)
    {
        $bonus = $amount * 0.001;
        $parentUser = User::find($parent_id);

        if (!$parentUser) {
            throw new \Exception('Parent user not found');
        }

        //$NX = new fiver();
        //$depositResponse = json_decode($NX->deposit($parentUser->name, $bonus));

        //if ($depositResponse->status !== 1) {
        //    throw new \Exception('Deposit to parent failed');
        //}

        //$balanceResponse = json_decode($NX->userbalance($parentUser->name));
        //if ($balanceResponse->status !== 1) {
        //    throw new \Exception('Parent user balance retrieval failed');
        //}

        $parentSaldo = Saldo::firstOrCreate(['user_id' => $parentUser->id]);
        $parentSaldo->saldo = $parentSaldo->saldo;
        $parentSaldo->save();
    }




    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
