<?php

namespace App\Http\Controllers\backoffice;

use App\Models\Bank;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DepositbankController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $bank = Bank::all();
        return view('admin.deposit_bank.deposit_bank', compact('bank'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validateData = $request->validate([
            'nama_bank' => 'required|max:255',
            'no_rek' => 'required|max:255',
            'nama_penerima' => 'required|max:255',
            'image_qr' => 'image|file|max:2024',
            'qris' => 'image|file|max:2024',
            'type' => 'required|max:255',
        ]);

        if ($request->file('image_qr')) {
            $validateData['image_qr'] = $request->file('image_qr')->store('post-images');
        }
      	if ($request->file('qris')) {
            $validateData['qris'] = $request->file('qris')->store('post-images');
        }

        $validateData['status'] = 1;
        Bank::create($validateData);

        return redirect('/deposit_bank')->with('success', 'Bank has been added!!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $bank = Bank::find($id);
        if ($request->status != null) {
            $bank->status = $request->status;
        } else {
            $bank->nama_bank = $request->nama_bank;
            $bank->nama_penerima = $request->nama_penerima;
            $bank->no_rek = $request->no_rek;
            $bank->type = $request->type;
        }

        if ($request->hasFile('image_qr')) {
            $bank->image_qr = $request->file('image_qr')->store('post-images');
        }
      	if ($request->file('qris')) {
            $bank['qris'] = $request->file('qris')->store('post-images');
        }
        $bank->save();
        return redirect('/deposit_bank')->with('success', 'Data Berhasil Diubah');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        // Temukan data berdasarkan ID
        $data = Bank::find($id);

        // Periksa apakah data ditemukan
        if (!$data) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        // Hapus data
        $data->delete();
        // Berikan respons sukses
        return redirect('/deposit_bank')->with('success', 'Data Bank Berhasil Dihapus');
    }
}
