<?php

namespace App\Http\Controllers\backoffice;

use App\Models\User;
use App\Http\Api\fiver;
use App\Models\Setting;
use App\Models\Game_list;
use App\Http\Api\wokakse;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;

class GameSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $SG = new fiver();
        $act = json_decode($SG->callPlayer());
        $data = $act->data;

        // Tambahkan ID auto increment, dimulai dari 1
        $dataWithIds = array_map(function ($item, $index) {
            $item->id = $index + 1; // Tambahkan ID auto increment, dimulai dari 1
            return $item;
        }, $data, array_keys($data));

        // Ubah urutan elemen sehingga 'id' berada di bagian atas
        $dataWithIds = array_map(function ($item) {
            return ['id' => $item->id] + (array) $item;
        }, $dataWithIds);

        return view(
            'admin.games.game_setting',
            [
                'x' => $dataWithIds
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Setting $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Setting $setting)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,  $id)
    {
        $data = Setting::find($id);
        $data->nama_web = $request->nama_web;
        $data->telp = $request->telp;
        $data->wa = $request->wa;
        $data->tele = $request->tele;
        $data->running_text = $request->running_text;
        $data->live_chat = $request->live_chat;
        $data->linkalter1 = $request->linkalter1;
        $data->msg_popup = $request->msg_popup;


        $data->bg_color = $request->bg_color;
        $data->bg_color_2 = $request->bg_color_2;
        $data->bg_color_single = isset($request->bg_color_single) ? $request->bg_color_single : 0;

        $data->nav_color = $request->nav_color;
        $data->nav_login = $request->nav_login;
        $data->nav_login_2 = $request->nav_login_2;
        $data->nav_color_trans = $request->nav_color_trans;
        $data->nav_color_2 = $request->nav_color_2;
        $data->txt_color = $request->txt_color;

        $data->maintenance_mode = isset($request->maintenance_mode) ? $request->maintenance_mode : 0;

        if ($request->hasFile('logo')) {

            $file_path = public_path() . '/storage/logo/' . $data->logo;
            if (File::exists($file_path)) {
                unlink($file_path);
            }

            $imgname = time() . '_' . $request->logo->getClientOriginalName();
            $request->logo->move(public_path() . '/storage/logo/', $imgname);

            $data->logo = $imgname;
        }

        $data->save();
        return redirect()->back()->with('success', 'Data berhasil diubah');
    }


    public function lock(Request $request)
    {
        $data = Game_list::find($request->game_id);
        $data->game_locked = 1;
        $data->save();

        return redirect()->back()->with('success', 'Data berhasil diubah');
    }

    public function unlock(Request $request)
    {
        $data = Game_list::find($request->game_id);
        $data->game_locked = 0;
        $data->save();

        return redirect()->back()->with('success', 'Data berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Setting $setting)
    {
        //
    }

    public function callList(Request $request)
    {
        $provider = $request->provider;
        $gamecode = $request->game_code;
        $username = $request->username;

        $SG = new fiver();
        $act = json_decode($SG->callList($provider, $gamecode, $username));
        return $act;
    }
    public function callApply(Request $request)
    {
        $provider = $request->input('provider');
        $gamecode = $request->input('game_code');
        $username = $request->input('username');
        $rtp = $request->input('call_rtp');
        $type = $request->input('call_type');


        if (!is_numeric($rtp)) {
            return response()->json(['status' => 'error', 'msg' => 'RTP must be a number'], 400);
        }

        $rtp = (int) $rtp;

        $SG = new fiver();
        $act = $SG->callApply($provider, $gamecode, $username, $rtp, $type);

        return response()->json(['status' => 'success', 'data' => $act]);
    }

    public function getGameHistory(Request $request)
    {
        $game_type = 'slot';
        $page = 0;
        $perPage = 1000;

        $date_start = $request->input('date_start');
        $date_end = $request->input('date_end');
        $extplayer = $request->input('name');


        $startDate = $date_start ? Carbon::parse($date_start)->startOfDay()->format('Y-m-d H:i:s') : Carbon::now('Asia/Jakarta')->startOfDay()->format('Y-m-d H:i:s');
        $endDate = $date_end ? Carbon::parse($date_end)->endOfDay()->format('Y-m-d H:i:s') : Carbon::now('UTC')->endOfDay()->format('Y-m-d H:i:s');

        $SG = new fiver();
        $act = json_decode($SG->historyPlay($extplayer, $game_type, $startDate, $endDate, $page, $perPage));

        $slot = $act->slot ?? [];
        return response()->json([
            'status' => 'success',
            'data' => $slot
        ]);
    }

    public function showForm()
    {
        $users = User::all();
        return view('admin.history_play.history', compact('users'));
    }
}
