<?php

namespace App\Http\Controllers\backoffice;

use App\Models\User;
use App\Models\Saldo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\API\softgaming;

class PengaturanSaldoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, Saldo $Saldo)
    {
        $src = empty($request->search) ? "" : addslashes(base64_decode($request->search));
        $saldo = new Saldo();
        $saldo = $saldo->saldo_list($src, 1);
        $id = $Saldo->id;
        return view('admin.pengaturan_saldo.pengaturan_saldo', [
            'saldo' => $saldo,
            'src' => $src,
            'id' => $id

        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        // Find the user


        // Find the user's balance
        $saldo_user = Saldo::find($id);
        $User = User::where('id', $saldo_user->user_id)->first();

        // Check if the request has 'type' and 'nominal' fields
        if ($request->has('type') && $request->has('nominal')) {
            // Calculate the new balance based on the request type
            if ($request->type == 1) {

                $SG = new softgaming();
                $act =  json_decode($SG->transaksi($User->name, 'deposit', $request->nominal));
                if ($act->status == 'success') {
                    $saldo_user->saldo += $request->nominal;
                } else {
                    return redirect()->back()->with('error', 'Terjadi Kesalahan Input');
                }
            } elseif ($request->type == 2) {

                $SG = new softgaming();
                $act =  json_decode($SG->transaksi($User->name, 'withdraw', $request->nominal));
                if ($act->status == 'success') {
                    $saldo_user->saldo -= $request->nominal;
                } else {
                    return redirect()->back()->with('error', 'Terjadi Kesalahan Input');
                }
            }
            // elseif ($request->type == 3) {
            //     // Add nominal to bonus
            //     $saldo_user->bonus += $request->nominal;
            // } elseif ($request->type == 4) {
            //     // Subtract nominal from bonus
            //     $saldo_user->bonus -= $request->nominal;
            // }

            // Save the changes to the saldo

        }

        $saldo_user->save();
        return redirect()->back()->with('success', 'Data berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
