<?php

namespace App\Http\Controllers\backoffice;

use App\Http\Api\fiver;
use App\Http\Api\softgaming;
use App\Http\Controllers\Controller;
use App\Models\Saldo;
use App\Models\Transaksi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class WithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $transaksi = Transaksi::where('type', 2)->get();

        return view('admin.withdraw.withdraw', compact('transaksi'));
    }

    public function confirm (Request $request, string $id)
    {
        $transaksi = Transaksi::where('user_id', $id)->where('type', 2)->where('status', 1)->first();
        $transaksi->status = 2;
        $transaksi->alasan = 'Berhasil transfer ke rek ' . $transaksi->rek_pengirim;
        $transaksi->save();
        return redirect()->back()->with('success', 'Withdraw berhasil diproses');
    }

    public function reject(Request $request, string $id)
    {
        $transaksi = Transaksi::where('user_id', $id)->where('type', 2)->where('status', 1)->first();
        $name = $transaksi->user_name;
        $amount = intval($transaksi->nominal);
        $user = Saldo::where('user_id', $transaksi->user_id)->first();
            $transaksi = Transaksi::where('user_id', $id)->where('type', 2)->where('status', 1)->first();
            $transaksi->status = 3;
            $transaksi->alasan = 'Reject by Admin';
            $transaksi->save();
            
            $saldo = Saldo::firstOrCreate(['user_id' => $user->id]);
            $saldo->saldo = $saldo->saldo + $amount;
            $saldo->save();
        return redirect()->back()->with('success', 'Withdraw berhasil ditolak, saldo akan dikembalikan');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    public function aksi(string $id, Request $request)
    {
        $transaksi = Transaksi::find($id);
        $transaksi->status = $request->status;
        $transaksi->save();

        return redirect()->back()->with('success', 'Data berhasil diubah');
    }
}
