<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Saldo_log;
use App\Models\User;

class Saldo extends Model
{
    use HasFactory;

    protected $table = 'saldo';
    protected $fillable = ['user_id', 'user_name', 'saldo']; // Kolom yang bisa diisi
    private $limit = 9999999999; // Batas saldo maksimum

    /**
     * Relasi ke tabel User
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    /**
     * Tambahkan saldo untuk user
     * 
     * @param float $amount
     * @return void
     */
    public function addSaldo(float $amount)
    {
        $this->saldo += $amount;

        // Pastikan saldo tidak melebihi batas
        if ($this->saldo > $this->limit) {
            $this->saldo = $this->limit;
        }

        $this->save();
    }

    /**
     * Kurangi saldo untuk user
     * 
     * @param float $amount
     * @return bool
     */
    public function deductSaldo(float $amount): bool
    {
        if ($this->saldo < $amount) {
            return false; // Gagal jika saldo tidak mencukupi
        }

        $this->saldo -= $amount;
        $this->save();

        return true;
    }

    /**
     * Simpan log saldo (Opsional)
     * 
     * @param string $type
     * @param float $amount
     * @param string|null $note
     * @return void
     */
    public function saveLog(string $type, float $amount, string $note = null)
    {
        Saldo_log::create([
            'user_id' => $this->user_id,
            'type' => $type,
            'amount' => $amount,
            'note' => $note,
        ]);
    }
}
