<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trans extends Model
{
    use HasFactory;

    // Nama tabel di database
    protected $table = 'transaksi'; // Sesuaikan dengan nama tabel Anda

    // Primary Key
    protected $primaryKey = 'id';

    // Kolom yang bisa diisi melalui mass assignment
    protected $fillable = [
        'ref',
        'type',
        'status',
        'trans_id',
        'bonus_id',
        'bonus_persentase',
        'nominal',
        'user_id',
        'user_name',
        'created_at',
        'updated_at',
        'approved_at',
        'approved_by',
        'bukti_transfer',
        'bank_id',
        'bank_tujuan',
        'rek_pengirim',
        'keterangan',
        'alasan',
        'qris_url',
    ];

    // Tipe kolom yang perlu otomatis menjadi instance Carbon (datetime)
    protected $dates = [
        'created_at',
        'updated_at',
        'approved_at',
    ];

    // Relasi dengan model User
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
