@foreach ($data_member as $item)
    <div class="modal fade" id="update-{{ $item->id }}" tabindex="-1" role="dialog"
        aria-labelledby="modalUpdate{{ $item->id }}" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('update.member', $item->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalUpdate{{ $item->id }}">Update Member: {{ $item->name }}
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="modal-body">
                            <div class="form-group">
                                <label for="nama">Username</label>
                                <input id="nama" type="text" class="form-control" name="nama"
                                    value="{{ $item->name }}" required pattern="^\S+$"
                                    title="Username tidak boleh mengandung spasi.">
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input id="password" type="text" class="form-control" name="password"
                                    value="">
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input id="email" type="email" class="form-control" name="email"
                                    value="{{ $item->email }}" required>
                            </div>
                            <div class="form-group">
                                <label for="telp">Whatsapp</label>
                                <input id="telp" type="number" class="form-control" name="telp"
                                    value="{{ $item->telp }}" required>
                            </div>
                            <div class="form-group">
                                <label for="ref_code">Reff Code</label>
                                <input id="ref_code" type="text" class="form-control" name="ref_code"
                                    value="{{ $item->ref_code }}">
                            </div>
                            <div class="form-group">
                                <label for="nama_rek">Nama Rek</label>
                                <input id="nama_rek" type="text" class="form-control" name="nama_rek"
                                    value="{{ $item->nama_rek }}" required>
                            </div>
                            <div class="form-group">
                                <label for="bank">Bank</label>
                                <select id="bank" name="bank" class="form-control" required>
                                    <option value="">- Silahkan pilih -</option>
                                    <option value="BCA" {{ $item->bank == 'BCA' ? 'selected' : '' }}>Bank Central
                                        Asia (BCA)</option>
                                    <option value="Mandiri" {{ $item->bank == 'Mandiri' ? 'selected' : '' }}>Bank
                                        Mandiri</option>
                                    <option value="BRI" {{ $item->bank == 'BRI' ? 'selected' : '' }}>Bank Rakyat
                                        Indonesia (BRI)</option>
                                    <option value="BNI" {{ $item->bank == 'BNI' ? 'selected' : '' }}>Bank Negara
                                        Indonesia (BNI)</option>
                                    <option value="BSI" {{ $item->bank == 'BSI' ? 'selected' : '' }}>Bank Syariah
                                        Indonesia (BSI)</option>
                                    <option value="Seabank" {{ $item->bank == 'Seabank' ? 'selected' : '' }}>Seabank
                                    </option>
                                    <option value="CIMB" {{ $item->bank == 'CIMB' ? 'selected' : '' }}>CIMB Niaga
                                    </option>
                                    <option value="BTN" {{ $item->bank == 'BTN' ? 'selected' : '' }}>Bank Tabungan
                                        Negara (BTN)</option>
                                    <option value="Danamon" {{ $item->bank == 'Danamon' ? 'selected' : '' }}>Bank
                                        Danamon</option>
                                    <option value="Permata" {{ $item->bank == 'Permata' ? 'selected' : '' }}>Bank
                                        Permata</option>
                                    <option value="OCBC" {{ $item->bank == 'OCBC' ? 'selected' : '' }}>OCBC NISP
                                    </option>
                                    <option value="Mega" {{ $item->bank == 'Mega' ? 'selected' : '' }}>Bank Mega
                                    </option>
                                    <option value="Maybank" {{ $item->bank == 'Maybank' ? 'selected' : '' }}>Maybank
                                        Indonesia</option>
                                    <option value="Panin" {{ $item->bank == 'Panin' ? 'selected' : '' }}>Bank Panin
                                    </option>
                                    <option value="BTPN" {{ $item->bank == 'BTPN' ? 'selected' : '' }}>Bank BTPN
                                    </option>
                                    <option value="Commonwealth" {{ $item->bank == 'Commonwealth' ? 'selected' : '' }}>
                                        Bank Commonwealth</option>
                                    <option value="Sinarmas" {{ $item->bank == 'Sinarmas' ? 'selected' : '' }}>Bank
                                        Sinarmas</option>
                                    <option value="Bukopin" {{ $item->bank == 'Bukopin' ? 'selected' : '' }}>Bank
                                        Bukopin</option>
                                    <option value="Mestika" {{ $item->bank == 'Mestika' ? 'selected' : '' }}>Bank
                                        Mestika</option>
                                    <option value="Woori Saudara"
                                        {{ $item->bank == 'Woori Saudara' ? 'selected' : '' }}>Bank Woori Saudara
                                    </option>
                                    <option value="MNC" {{ $item->bank == 'MNC' ? 'selected' : '' }}>Bank MNC
                                    </option>
                                    <option value="BJB" {{ $item->bank == 'BJB' ? 'selected' : '' }}>Bank Jawa Barat
                                        dan Banten (BJB)</option>
                                    <option value="BPD Bali" {{ $item->bank == 'BPD Bali' ? 'selected' : '' }}>Bank
                                        Pembangunan Daerah Bali</option>
                                    <option value="BPD Jatim" {{ $item->bank == 'BPD Jatim' ? 'selected' : '' }}>Bank
                                        Pembangunan Daerah Jawa Timur (BPD Jatim)</option>
                                    <option value="BPD Jateng" {{ $item->bank == 'BPD Jateng' ? 'selected' : '' }}>Bank
                                        Pembangunan Daerah Jawa Tengah (BPD Jateng)</option>
                                    <option value="BPD DIY" {{ $item->bank == 'BPD DIY' ? 'selected' : '' }}>Bank
                                        Pembangunan Daerah DIY</option>
                                    <option value="BPD Sumut" {{ $item->bank == 'BPD Sumut' ? 'selected' : '' }}>Bank
                                        Sumut</option>
                                    <option value="BPD Aceh" {{ $item->bank == 'BPD Aceh' ? 'selected' : '' }}>Bank
                                        Aceh</option>
                                    <option value="BPD Sulselbar"
                                        {{ $item->bank == 'BPD Sulselbar' ? 'selected' : '' }}>Bank Sulawesi Selatan
                                        dan Barat (BPD Sulselbar)</option>
                                    <option value="BPD Kalbar" {{ $item->bank == 'BPD Kalbar' ? 'selected' : '' }}>
                                        Bank Kalimantan Barat (BPD Kalbar)</option>
                                    <option value="BPD Kaltimtara"
                                        {{ $item->bank == 'BPD Kaltimtara' ? 'selected' : '' }}>Bank Kaltimtara
                                    </option>
                                    <option value="BPD Sumsel Babel"
                                        {{ $item->bank == 'BPD Sumsel Babel' ? 'selected' : '' }}>Bank Sumsel Babel
                                    </option>
                                    <option value="">- Silahkan pilih E-Wallet -</option>
                                    <option value="GoPay" {{ $item->bank == 'GoPay' ? 'selected' : '' }}>GoPay
                                    </option>
                                    <option value="OVO" {{ $item->bank == 'OVO' ? 'selected' : '' }}>OVO</option>
                                    <option value="DANA" {{ $item->bank == 'DANA' ? 'selected' : '' }}>DANA</option>
                                    <option value="LinkAja" {{ $item->bank == 'LinkAja' ? 'selected' : '' }}>LinkAja
                                    </option>
                                    <option value="ShopeePay" {{ $item->bank == 'ShopeePay' ? 'selected' : '' }}>
                                        ShopeePay</option>
                                    <option value="SakuKu" {{ $item->bank == 'SakuKu' ? 'selected' : '' }}>Sakuku
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="no_rek">No Rek</label>
                                <input id="no_rek" type="number" class="form-control" name="no_rek"
                                    value="{{ $item->no_rek }}" required>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endforeach
