@foreach ($sgProvider as $provider)
    <div class="modal fade" id="updateProvider{{ $provider->id }}" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('update.provider', [($provider->id)] )}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Update Provider</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="provider_code">Provider Code</label>
                            <input class="form-control" type="text" name="provider_code" id="" value="{{ $provider->provider_code}}" required>
                        </div>
                        <div class="form-group">
                            <label for="provider_name">Nama Provider</label>
                            <input type="text" class="form-control" name="provider_name" value="{{ $provider->provider_name}}" required>
                        </div>
                        <div class="form-group">
                            <label for="no">Type Provider</label>
                            <input type="text" class="form-control" name="provider_type" value="{{ $provider->provider_type}}" required>
                        </div>
                        <div>
                            <label for="type">Status</label>
                            <select class="form-control" name="provider_status" id="" required>
                                <option value="1" {{ $provider->provider_status == 1 ? 'selected' : '' }}>Aktif</option>
                                <option value="0" {{ $provider->provider_status == 0 ? 'selected' : '' }}>Tidak Aktif</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="qr">Desktop Background</label>
                            <input type="file" class="form-control" name="provider_background"
                                accept="image/png, image/jpg, image/jpeg">
                        </div>
                        <div class="form-group">
                            <label for="qr">Mobile Background</label>
                            <input type="file" class="form-control" name="mobile_provider_background"
                                accept="image/png, image/jpg, image/jpeg">
                        </div>
                        <div class="form-group">
                            <label for="qr">Provider Image</label>
                            <input type="file" class="form-control" name="provider_image"
                                accept="image/png, image/jpg, image/jpeg">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endforeach
