@extends('admin.layouts.main')

@section('content')

    <div class="card mt-3">
        <div class="card-header">
            Data Deposit Member
        </div>
        @if (Session::has('success'))
            <div class="alert alert-success">
                {{ Session::get('success') }}
            </div>
        @endif
        @if (Session::has('error'))
            <div class="alert alert-danger">
                {{ Session::get('error') }}
            </div>
        @endif
        <div class="card-body">
            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Username</th>
                        <th>Rek Pengirim</th>
                        <th>Tujuan</th>
                        <th>Deposit</th>
                        <th>Bonus</th>
                        <th>Keterangan</th>
                        <th>Bukti TF</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($transaksi as $index => $transaksis)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $transaksis->created_at}}</td>
                            <td>{{ $transaksis->user_name }}</td>
                            <td>{{ $transaksis->rek_pengirim }}</td>
                            <td>{{ $transaksis->bank_tujuan }}</td>
                            <td>Rp {{ number_format($transaksis->nominal, 0, ',', '.') }}</td>
                            <td>
                                @php
                                    $bonus = $bonuses->where('id', $transaksis->bonus_id)->first();
                                @endphp
                                {{ $bonus->judul ?? 'Tidak ada bonus' }}
                            </td>
                            <td>{{ $transaksis->keterangan }}</td>
                            <td>
                                @if ($transaksis->bukti_transfer)
                                    <a href="{{ asset('storage/' . $transaksis->bukti_transfer) }}" target="_blank">Lihat Bukti</a>
                                @else
                                    Tidak Ada Bukti
                                @endif
                            </td>
                            <td>
                                @if ($transaksis->status == 1)
                                    <!-- Tombol untuk memunculkan modal konfirmasi -->
                                    <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#confirmModal-{{ $transaksis->id }}">
                                        Konfirmasi
                                    </button>

                                    <form action="{{ route('depo.reject', $transaksis->id) }}" method="POST" style="display: inline;">
                                        @csrf
                                        @method('PUT')
                                        <button type="submit" class="btn btn-sm btn-warning">Reject</button>
                                    </form>
                                @elseif($transaksis->status == 2)
                                    <span style="color: rgb(21, 128, 0)"><strong>Sukses</strong></span>
                                @elseif($transaksis->status == 3)
                                    <span style="color: rgb(128, 0, 0)"><strong>Reject</strong></span>
                                @endif
                            </td>
                        </tr>

                        <!-- Modal Konfirmasi -->
                        <div class="modal fade" id="confirmModal-{{ $transaksis->id }}" tabindex="-1" role="dialog" aria-labelledby="confirmModalLabel-{{ $transaksis->id }}" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="confirmModalLabel-{{ $transaksis->id }}">Konfirmasi Transaksi</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        Apakah Anda yakin ingin mengonfirmasi transaksi ini? Tindakan ini tidak dapat dibatalkan!
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Tidak</button>
                                        <form action="{{ route('depo.confirm', $transaksis->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PUT')
                                            <button type="submit" class="btn btn-primary">Ya, Konfirmasi!</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    @empty
                        <tr>
                            <td colspan="10" class="text-center">Tidak ada transaksi ditemukan</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

@endsection
