@extends('admin.layouts.main')
@section('content')
<div class="pt-3">
    <button data-toggle="modal" data-target="#tambah" type="button" class="btn btn-success btn-add"><i
            class="fa fa-plus"></i> Update Game</button>
</div>
<div class="card mt-3">
    <div class="card-header">
        Data Game
    </div>
    <div class="card-body">
        @include('admin.layouts.msg_bar')
        <div class="table-responsive">
            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Game</th>
                        <th>Provide</th>
                        <th>Category</th>
                        <th>Gambar</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($games as $game)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $game->game_name }}</td>
                        <td>{{ $game->game_provider }}</td>
                        <td>{{ $game->game_category}}</td>
                        <td> {{ $game->game_image }}</td>

                        <td>
                            <button data-toggle="modal" data-target="#update-{{ $game->id }}" type="button" class="btn btn-primary">
                                <i class="fas fa-pen"></i>
                            </button>
                            <button data-toggle="modal" data-target="#delete{{ $game->id }}"
                                data-member="{{ json_encode($game) }}" type="button"
                                class="btn btn-danger btn-ubah"><i class="fas fa-trash"></i></button>

                        </td>
                        {{-- <div class="modal fade" id="delete{{ $item->id }}" tabindex="-1"
                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <form action="{{ route('data_member.destroy', $item->id) }}" method="POST"
                                        enctype="multipart/form-data">
                                        {{ csrf_field() }}
                                        @method('DELETE')
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Hapus Data Member</h5>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            Apakah anda yakin akan manghapus data member ?
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-danger">Hapus Data</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div> --}}
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
{{-- @include('backoffice.component.addMember')
@include('backoffice.component.updateMember') --}}

@endsection