@extends('admin.layouts.main')
@section('content')
<div class="card mt-3">
    <div class="card-header">
        Data Game
    </div>
    <div class="card-body">
        @include('admin.layouts.msg_bar')
        <div class="table-responsive">
            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Provider</th>
                        <th>Code</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Background</th>
                        <th>Mobile Background</th>
                        <th>Provider Image</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($sgProvider as $provider)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $provider->provider_name }}</td>
                        <td>{{ $provider->provider_code }}</td>
                        <td>{{ $provider->provider_type}}</td>
                        <td>
                            @if ($provider->provider_status == 1)
                                Aktif
                            @else
                                Non-Aktif
                            @endif
                        </td>
                        <td><img src="{{ asset('storage/' . $provider->provider_background) }}" style="max-height: 50px" alt=""></td>
                        <td><img src="{{ asset('storage/' . $provider->mobile_provider_background) }}" style="max-height: 50px" alt=""></td>
                        <td><img src="{{ asset('storage/' . $provider->provider_image) }}" style="max-height: 50px" alt=""></td>

                        <td>
                            <button data-toggle="modal" data-target="#updateProvider{{ $provider->id }}" type="button" class="btn btn-primary">
                                <i class="fas fa-pen"></i>
                            </button>
                            <button data-toggle="modal" data-target="#delete{{ $provider->id }}"
                                data-member="{{ json_encode($provider) }}" type="button"
                                class="btn btn-danger btn-ubah"><i class="fas fa-trash"></i></button>

                        </td>
                        <div class="modal fade" id="delete{{ $provider->id }}" tabindex="-1"
                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <form action="{{ route('delete.provider', $provider->id) }}" method="POST"
                                        enctype="multipart/form-data">
                                        {{ csrf_field() }}
                                        @method('DELETE')
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Hapus Data Member</h5>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            Apakah anda yakin akan manghapus data member ?
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-danger">Hapus Data</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@include('admin.component.updateProvider')

@endsection