<?php

use Illuminate\Support\Facades\Auth;

$user_level = Auth::user()->level;
$is_developer = (int) $user_level === 2;
$is_admin = (int) $user_level <= 2;

?>
@extends('admin.layouts.main')

@section('content')
    <div class="card mt-3">
        <div class="card-header">
            <button id="generate-voucher-btn">Generate Voucher</button>
            <p style="color: black" id="voucher-code-display"></p>
        </div>

        <div class="card-header">

        </div>

        <div class="card-body">
            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th scope="col">Tanggal</th>
                        <th>Code</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($Voucher as $Voucher)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $Voucher->created_at }}</td>
                            <td>{{ $Voucher->code }}</td>
                            @if ($Voucher->is_valid == true)
                                <td>Belum Terpakai</td>
                            @else
                                <td>Sudah Terpakai</td>
                            @endif
                            <td></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#generate-voucher-btn').click(function() {
                $.ajax({
                    url: '/generate-voucher',
                    type: 'POST',
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(data) {
                        $('#voucher-code-display').text('Generated Voucher Code: ' + data
                            .voucher_code);
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error: ' + status + ' ' + error);
                    }
                });
            });
        });

        $('#example2').DataTable({
            paging: true,
            lengthChange: true,
            searching: true,
            ordering: true,
            info: true,
            autoWidth: false,
            responsive: true,
            order: [
                [1, 'desc']
            ],
            bState: false,
            bAutoWidth: false,
            data: datatables_data,
            aoColumns: [{
                    sWidth: '5%',
                    mData: 'iteration'
                },
                {
                    sWidth: '5%',
                    mData: 'created_at'
                },
                {
                    sWidth: '15%',
                    mData: 'username'
                },
                {
                    sWidth: '8%',
                    mData: 'rekening'
                },
                {
                    sWidth: '8%',
                    mData: 'bank'
                },
                {
                    sWidth: '10%',
                    mData: 'nominal'
                },
                {
                    sWidth: '8%',
                    mData: 'bonus'
                },
                {
                    sWidth: '10%',
                    mData: 'keterangan'
                },
                {
                    sWidth: '5%',
                    mData: "id",
                    mRender: render_transfer
                },
                {
                    sWidth: '10%',
                    mData: "id",
                    mRender: render_action
                }

            ]
        });
    </script>
@endsection
