@extends('admin.layouts.main')

@section('content')
    <div class="pt-3">
        <h4>Info Downline Member</h4>
    </div>

    @if (Session::has('success'))
        <script type="text/javascript">
            Swal.fire(
                'Berhasil',
                '{{ Session::get('success') }}',
                'success'
            );
        </script>
    @endif
    @if (Session::has('error'))
        <script type="text/javascript">
            Swal.fire(
                'Warning',
                '{{ Session::get('error') }}',
                'error'
            );
        </script>
    @endif

    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <!-- Sidebar Member Info -->
                <div class="col-md-3">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <img class="profile-user-img img-fluid img-circle"
                                    src="https://adminlte.io/themes/v3/dist/img/user4-128x128.jpg"
                                    alt="User profile picture">
                                <div class="profile-username text-center">{{ $user->name }}</div>
                                <ul class="list-group list-group-unbordered mb-3">
                                    <li class="list-group-item">
                                        <b>Tgl Register : </b>
                                        <a class="float-right">{{ $user->created_at->format('d-m-Y') }}</a>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Total Downline : </b>
                                        <a class="float-right">{{ $totalDownline }} Member</a>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Total DP Member </b>
                                        <a class="float-right">Rp {{ number_format($totalFirstDeposit, 0, ',', '.') }}</a>
                                    </li>
                                </ul>
                                <button data-toggle="modal" data-target="#delete{{ $user->id }}"
                                    data-member="{{ json_encode($user) }}" type="button"
                                    class="btn btn-danger btn-block"><i class="fas fa-trash"></i> Delete</button>
                                <div class="modal fade" id="delete{{ $user->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="{{ route('data_member.destroy', $user->id) }}" method="POST"
                                                enctype="multipart/form-data">
                                                {{ csrf_field() }}
                                                @method('DELETE')
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Hapus Data Member</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Apakah anda yakin akan manghapus data member ?
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Hapus Data</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <p>
                                    @if ($user->email_verified_at)
                                        @if ($user->status_reff == 0)
                                            <form action="{{ route('on.reff', ['id' => $user->id]) }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="reff_status" value="1">
                                                <button type="submit" class="btn btn-primary btn-block">Konfirmasi
                                                    Reff</button>
                                            </form>
                                        @else
                                            <form action="{{ route('off.reff', ['id' => $user->id]) }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="reff_status" value="0">
                                                <button type="submit" class="btn btn-warning btn-block">Nonaktifkan
                                                    Reff</button>
                                            </form>
                                        @endif
                                    @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab Content (Right Side) -->
                <div class="col-md-9">
                    <div class="card">
                        <div class="card-header p-2">
                            <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                                <!-- Tab Downline -->
                                <li class="nav-item" style="margin-right: 5px">
                                    <a class="nav-link active" id="downline-tab" data-toggle="pill" href="#downline"
                                        role="tab" aria-controls="downline" aria-selected="true">Downline</a>
                                </li>
                                <!-- Tab Update -->
                                <li class="nav-item" style="margin-right: 5px">
                                    <a class="nav-link" id="update-tab" data-toggle="pill" href="#update" role="tab"
                                        aria-controls="update" aria-selected="false">Update</a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content" id="custom-tabs-three-tabContent">
                                <!-- Tab Downline Content -->
                                <div class="tab-pane fade active show" id="downline" role="tabpanel"
                                    aria-labelledby="downline-tab">
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th>Username</th>
                                                <th>Tgl Daftar</th>
                                                <th>Deposit Pertama</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($downlines as $downline)
                                                <tr>
                                                    <td>{{ $downline->name }}</td>
                                                    <td>{{ $downline->created_at->format('d-m-Y') }}</td>
                                                    <td>
                                                        {{ isset($deposits[$downline->name]) ? $deposits[$downline->name] : 0 }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Tab Update Content -->
                                <div class="tab-pane fade" id="update" role="tabpanel" aria-labelledby="update-tab">
                                    <form action="{{ route('update.member', $user->id) }}" method="POST"
                                        enctype="multipart/form-data">
                                        @csrf
                                        @method('PUT')
                                        <div class="form-group">
                                            <label for="nama">Username</label>
                                            <input id="nama" type="text" class="form-control" name="nama"
                                                value="{{ $user->name }}" required pattern="^\S+$"
                                                title="Username tidak boleh mengandung spasi.">
                                        </div>
                                        <div class="form-group">
                                            <label for="password">Password</label>
                                            <input id="password" type="password" class="form-control" name="password"
                                                value="">
                                        </div>
                                        <div class="form-group">
                                            <label for="email">Email</label>
                                            <input id="email" type="email" class="form-control" name="email"
                                                value="{{ $user->email }}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="telp">Whatsapp</label>
                                            <input id="telp" type="number" class="form-control" name="telp"
                                                value="{{ $user->telp }}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="ref_code">Reff Code</label>
                                            <input id="ref_code" type="text" class="form-control" name="ref_code"
                                                value="{{ $user->ref_code }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="nama_rek">Nama Rek</label>
                                            <input id="nama_rek" type="text" class="form-control" name="nama_rek"
                                                value="{{ $user->nama_rek }}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="bank">Bank</label>
                                            <select id="bank" name="bank" class="form-control" required>
                                                <option value="">- Silahkan pilih -</option>
                                                <option value="BCA" {{ $user->bank == 'BCA' ? 'selected' : '' }}>Bank
                                                    Central Asia (BCA)</option>
                                                <option value="Mandiri" {{ $user->bank == 'Mandiri' ? 'selected' : '' }}>
                                                    Bank Mandiri</option>
                                                <option value="BRI" {{ $user->bank == 'BRI' ? 'selected' : '' }}>Bank
                                                    Rakyat Indonesia (BRI)</option>
                                                <option value="BNI" {{ $user->bank == 'BNI' ? 'selected' : '' }}>Bank
                                                    Negara Indonesia (BNI)</option>
                                                <option value="BSI" {{ $user->bank == 'BSI' ? 'selected' : '' }}>Bank
                                                    Syariah Indonesia (BSI)</option>
                                                <option value="Seabank" {{ $user->bank == 'Seabank' ? 'selected' : '' }}>
                                                    Seabank</option>
                                                <option value="CIMB" {{ $user->bank == 'CIMB' ? 'selected' : '' }}>CIMB
                                                    Niaga</option>
                                                <option value="BTN" {{ $user->bank == 'BTN' ? 'selected' : '' }}>Bank
                                                    Tabungan Negara (BTN)</option>
                                                <option value="Danamon" {{ $user->bank == 'Danamon' ? 'selected' : '' }}>
                                                    Bank Danamon</option>
                                                <option value="Permata" {{ $user->bank == 'Permata' ? 'selected' : '' }}>
                                                    Bank Permata</option>
                                                <option value="OCBC" {{ $user->bank == 'OCBC' ? 'selected' : '' }}>OCBC
                                                    NISP</option>
                                                <option value="Mega" {{ $user->bank == 'Mega' ? 'selected' : '' }}>Bank
                                                    Mega</option>
                                                <option value="Maybank" {{ $user->bank == 'Maybank' ? 'selected' : '' }}>
                                                    Maybank Indonesia</option>
                                                <option value="Panin" {{ $user->bank == 'Panin' ? 'selected' : '' }}>Bank
                                                    Panin</option>
                                                <option value="BTPN" {{ $user->bank == 'BTPN' ? 'selected' : '' }}>Bank
                                                    BTPN</option>
                                                <option value="Commonwealth"
                                                    {{ $user->bank == 'Commonwealth' ? 'selected' : '' }}>Bank Commonwealth
                                                </option>
                                                <option value="Sinarmas"
                                                    {{ $user->bank == 'Sinarmas' ? 'selected' : '' }}>Bank Sinarmas
                                                </option>
                                                <option value="Bukopin" {{ $user->bank == 'Bukopin' ? 'selected' : '' }}>
                                                    Bank Bukopin</option>
                                                <option value="Mestika" {{ $user->bank == 'Mestika' ? 'selected' : '' }}>
                                                    Bank Mestika</option>
                                                <option value="Woori Saudara"
                                                    {{ $user->bank == 'Woori Saudara' ? 'selected' : '' }}>Bank Woori
                                                    Saudara</option>
                                                <option value="MNC" {{ $user->bank == 'MNC' ? 'selected' : '' }}>Bank
                                                    MNC</option>
                                                <option value="BJB" {{ $user->bank == 'BJB' ? 'selected' : '' }}>Bank
                                                    Jawa Barat dan Banten (BJB)</option>
                                                <option value="BPD Bali"
                                                    {{ $user->bank == 'BPD Bali' ? 'selected' : '' }}>Bank Pembangunan
                                                    Daerah Bali</option>
                                                <option value="BPD Jatim"
                                                    {{ $user->bank == 'BPD Jatim' ? 'selected' : '' }}>Bank Pembangunan
                                                    Daerah Jawa Timur (BPD Jatim)</option>
                                                <option value="BPD Jateng"
                                                    {{ $user->bank == 'BPD Jateng' ? 'selected' : '' }}>Bank Pembangunan
                                                    Daerah Jawa Tengah (BPD Jateng)</option>
                                                <option value="BPD DIY" {{ $user->bank == 'BPD DIY' ? 'selected' : '' }}>
                                                    Bank Pembangunan Daerah DIY</option>
                                                <option value="BPD Sumut"
                                                    {{ $user->bank == 'BPD Sumut' ? 'selected' : '' }}>Bank Sumut</option>
                                                <option value="BPD Aceh"
                                                    {{ $user->bank == 'BPD Aceh' ? 'selected' : '' }}>Bank Aceh</option>
                                                <option value="BPD Sulselbar"
                                                    {{ $user->bank == 'BPD Sulselbar' ? 'selected' : '' }}>Bank Sulawesi
                                                    Selatan dan Barat (BPD Sulselbar)</option>
                                                <option value="BPD Kalbar"
                                                    {{ $user->bank == 'BPD Kalbar' ? 'selected' : '' }}>Bank Kalimantan
                                                    Barat (BPD Kalbar)</option>
                                                <option value="BPD Kaltimtara"
                                                    {{ $user->bank == 'BPD Kaltimtara' ? 'selected' : '' }}>Bank Kaltimtara
                                                </option>
                                                <option value="BPD Sumsel Babel"
                                                    {{ $user->bank == 'BPD Sumsel Babel' ? 'selected' : '' }}>Bank Sumsel
                                                    Babel</option>
                                                <option value="">- Silahkan pilih E-Wallet -</option>
                                                <option value="GoPay" {{ $user->bank == 'GoPay' ? 'selected' : '' }}>
                                                    GoPay</option>
                                                <option value="OVO" {{ $user->bank == 'OVO' ? 'selected' : '' }}>OVO
                                                </option>
                                                <option value="DANA" {{ $user->bank == 'DANA' ? 'selected' : '' }}>DANA
                                                </option>
                                                <option value="LinkAja" {{ $user->bank == 'LinkAja' ? 'selected' : '' }}>
                                                    LinkAja</option>
                                                <option value="ShopeePay"
                                                    {{ $user->bank == 'ShopeePay' ? 'selected' : '' }}>ShopeePay</option>
                                                <option value="SakuKu" {{ $user->bank == 'SakuKu' ? 'selected' : '' }}>
                                                    Sakuku</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="no_rek">No Rek</label>
                                            <input id="no_rek" type="number" class="form-control" name="no_rek"
                                                value="{{ $user->no_rek }}" required>
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-block">Update</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
