<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">

    <title>Detail Pembayaran</title>
    <style>
        /* Global Styles */
        body {
            margin: 0;
            padding: 20px;
            font-family: Arial, sans-serif;
            background-color: {{ $setting->popup_bg ?? '#ffffff' }};
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .card {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            overflow: hidden;
        }

        .card-header {
            background-color: #f8f9fa;
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
        }

        .card-title {
            margin: 0;
            font-size: 1.25rem;
            font-weight: 600;
        }

        .card-body {
            padding: 15px;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-size: 1rem;
            color: #333;
        }

        .form-control {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #ced4da;
            border-radius: 5px;
            background-color: #e9ecef;
        }

        .input-group {
            display: flex;
        }

        .input-group .form-control {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }


        .btn-primary:hover {
            background-color: #0056b3;
        }

        .text-center {
            text-align: center;
        }

        .shadow-lg {
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }

        small {
            color: #6c757d;
            display: block;
            margin-top: 5px;
        }

        /* Responsive Design */
        @media (max-width: 576px) {
            .card {
                width: 100%;
                margin: 10px;
            }

            .card-body {
                padding: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="card shadow-lg">
        <div class="card-header align-items-center d-flex">
            <h5 class="card-title mb-0 fw-semibold flex-grow-1">Pembayaran {{ $setting->nama_web }}</h5>
        </div>

        <!-- Timer Mundur -->
        <div class="card-body">
            <div class="form-group">
                <label for="Metode Pembayaran" class="form-label">Metode Pembayaran</label>
                <input value="QRIS Otomatis" class="form-control" disabled>
            </div>
        </div>
        <div class="card-body">
            <div class="form-group m-0">
                <label for="Jumlah Bayar" class="form-label">Jumlah Bayar</label>
                <div class="input-group">
                    <input type="text" class="form-control" disabled
                        value="{{ $nominal ? 'Rp ' . number_format($nominal, 0, ',', '.') : 'Rp 0' }}">
                    <button onclick="copyToClipboard('{{ $nominal }}')" class="btn btn-primary"><i
                            class="bx bx-copy-alt"></i></button>
                </div>
            </div>
        </div>
        <div class="card-body text-center">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div style="border-radius: 10px; background:{{ $setting->popup_bg }} ; padding:10px">
                        <a href="#" data-bs-toggle="modal" data-bs-target=".bs-example-modal-qris">
                            @if ($statusReq == 'new')
                                <img id="qr-code" class="qr-image" height="200"
                                    src="{{ route('qrcode.show', ['encodedUrl' => $encodedUrl]) }}" alt="QR Code">
                            @else
                                @if ($payQRIS)
                                    <img src="{{ $payQRIS }}" id="qr-code" class="qr-image" height="200"
                                        alt="QR Code">
                                @else
                                    <div style="text-align: center; color: red; font-weight: bold;">
                                        QRIS kadaluarsa
                                    </div>
                                @endif
                            @endif
                        </a>
                    </div>

                    <small>*SCAN QR Untuk melakukan pembayaran</small>
                    <small>Tekan <strong>Konfimasi</strong> jika tidak redirect</small>
                    {{-- <button type="button" class="btn btn-primary">Konfirmasi</button> --}}
                    <a href="{{ route('status.payment') }}" class="btn btn-primary">Konfrimasi</a>
                    <a href="{{ url()->previous() }}" class="">Kembali</a>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<script>
    // Timer Mundur 5 Menit
    let timerDuration = 5 * 60; // 5 menit dalam detik
    const timerElement = document.getElementById('timer');
    const interval = setInterval(() => {
        let minutes = Math.floor(timerDuration / 60);
        let seconds = timerDuration % 60;
        seconds = seconds < 10 ? '0' + seconds : seconds;
        timerElement.textContent = `Waktu tersisa: ${minutes}:${seconds}`;
        if (--timerDuration < 0) {
            clearInterval(interval);
            timerElement.textContent = 'Waktu habis!';
            // Disable download button and QR code when time is up
            document.getElementById('download-btn').disabled = true;
            document.getElementById('qr-code').style.opacity = 0.5;
        }
    }, 1000);

    // Fungsi untuk copy nominal ke clipboard
    function copyToClipboard(value) {
        var tempInput = document.createElement("input");
        tempInput.style.position = "absolute";
        tempInput.style.left = "-9999px";
        tempInput.value = value;
        document.body.appendChild(tempInput);
        tempInput.select();
        document.execCommand("copy");
        document.body.removeChild(tempInput);
        alert("Jumlah Bayar " + value + " berhasil disalin ke clipboard!");
    }

    // Download QR Code
    document.getElementById('download-btn').addEventListener('click', function() {
        const qrCodeImage = document.getElementById('qr-code');
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        canvas.width = qrCodeImage.naturalWidth;
        canvas.height = qrCodeImage.naturalHeight;
        context.drawImage(qrCodeImage, 0, 0);

        // Buat tautan untuk download
        const link = document.createElement('a');
        link.href = canvas.toDataURL('image/png');
        link.download = 'qrcode.png';
        link.click();
    });
    document.addEventListener('contextmenu', function(event) {
        event.preventDefault();
    });
</script>
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap 4 -->
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
