@extends('layouts.main')

@section('desktop')
    <div class="container pt-4 games-category">
        <div class="row">
            @php
                $games = [
                    ['code' => 'QBTatWW0l', 'provider' => 'PragmaticPlay', 'img' => 'casino_pp.jpg', 'logo' => 'pp_casino.png'],
                    ['code' => 'Lb330YXKf', 'provider' => 'WMCasino', 'img' => 'casino_wm.jpg', 'logo' => 'wm_casino.png'],
                    ['code' => 'sWCz8JpLT', 'provider' => 'VivoGaming', 'img' => 'w_casino.png', 'logo' => 'w_casino.png'],
                    ['code' => 'Wj6YKLdMw', 'provider' => 'DreamGaming', 'img' => 'casino_dreamgame.jpg', 'logo' => 'dream_casino.png'],
                    ['code' => 'fS4Rw13UO', 'provider' => 'Skywind', 'img' => 'casino_skywind.jpg', 'logo' => 'skywind_casino.png'],
                ];
            @endphp

            @foreach ($games as $game)
                <div class="col-xs-12 col-sm-4 col-lg-3 box gamecategory-singleitem">
                    <a href="{{ auth()->check() ? URL::to('subGameLaunch?game_code=' . $game['code'] . '&provider=' . $game['provider'] . '&game_type=2') : '#' }}" 
                        target="_blank" rel="opener" class="game {{ auth()->check() ? '' : 'login-alert' }}">
                        
                        <div class="g-card">
                            <div class="card-img">
                                <div class="g-overlay"></div>
                                <img src="https://files.sitestatic.net/GameImage/CasinoProviders/desktop/normal/{{ $game['img'] }}?v=16.2" alt="{{ $game['provider'] }}">
                                <div class="card-title">
                                    <div class="logo">
                                        <span style="width: 200px; height: 60px;">
                                            <img src="https://files.sitestatic.net/assets/imgs/game_logos/200x60/{{ $game['logo'] }}">
                                        </span>
                                    </div>
                                </div>
                                <div class="btn-wrapper">
                                    <button class="btn btn-hvrplay clearfix">
                                        <div class="inner">
                                            <div class="p1">MAIN SEKARANG</div>
                                            <div class="p2"><i class="icon-play-solid"></i></div>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>

                    </a>
                </div>
            @endforeach
        </div>
    </div>
@endsection

@section('content')
    <div class="container pt-1 games-category">
        <h2 class="title">Casino</h2>
        <div class="row">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 image-grid">
                    @foreach ($games as $game)
                        <div class="col-xs-4 col-sm-3 col-md-2 box">
                            <div class="game-wrapper">
                                <a href="{{ auth()->check() ? URL::to('subGameLaunch?game_code=' . $game['code'] . '&provider=' . $game['provider'] . '&game_type=2') : '#' }}" 
                                    target="_blank" rel="opener" class="game {{ auth()->check() ? '' : 'login-alert' }}">
                                    
                                    <img class="img-fluid lazy" alt="{{ $game['provider'] }}"
                                        data-src="https://files.sitestatic.net/GameImage/CasinoProviders/mobile/normal/{{ $game['img'] }}?v=9" />
                                    
                                    <div class="g-title">{{ $game['provider'] }}</div>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div class="mobilesite-footer">
        <div class="container">
            <style media="screen">
                .left-custom-livechat-code { bottom: 58px !important; }
                #chat-widget-container { bottom: 51px !important; }
            </style>
        </div>
    </div>
@endsection
