<?php

use App\Http\Controllers\Auth\RegisterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OtpController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Test Route 
Route::post('/register-otp', [RegisterController::class, 'registerOtp']);
Route::post('/verify-otp', [OtpController::class, 'verifyOtp']);
Route::post('/resend-otp', [OtpController::class, 'resendOtp']);
Route::post('/submit-refferal', [OtpController::class, 'storeRefferal'])->name('refferal.submit');

Route::post('/reg-gs', [HomeController::class, 'gs']);
Route::get('/launch-gs', [HomeController::class, 'launcGameReq']);


Route::namespace('Api')->group(function () {
    Route::post('Seamless/{method}', 'SeamlesController@seamles')->name('apis.seamlescallback');
    Route::get('GetGamelist', 'SeamlesController@GetGamelist')->name('apis.GetGamelist');
});