<?php

use App\Http\Api\Activate;
use App\Http\Api\bgx;
use App\Http\Api\wokakse;
use App\Models\Game;
use App\Models\User;
use App\Models\Saldo;
use App\Models\Banner;
use App\Http\Api\fiver;
use App\Http\Api\LicenseBoxExternalAPI;
use App\Models\Setting;
use App\Models\Game_api;
use App\Models\Game_list;
use App\Models\Transaksi;
use App\Models\Fiver_Game;
use Illuminate\Http\Request;
use App\Models\BannerPromosi;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\ActivateController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\GameController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SpinController;
use Illuminate\Support\Facades\Redirect;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\InjectController;
use App\Http\Controllers\AddGameController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\VoucherController;
use App\Http\Controllers\RefferalController;
use App\Http\Controllers\TurnoverController;
use App\Http\Controllers\QrisCallbackController;

use App\Http\Controllers\AdminLoginController;
use App\Http\Controllers\Api\WzGamesController;
use App\Http\Controllers\UserDepositController;
use App\Http\Controllers\UserHistoryController;
use App\Http\Controllers\UserWithdrawController;
use App\Http\Controllers\UserPernyataanController;
use App\Http\Controllers\backoffice\IconController;
use App\Http\Controllers\GetSaldoController;
use App\Http\Controllers\Auth\RegisterController;

use App\Http\Controllers\backoffice\LogoController;
use App\Http\Controllers\backoffice\BonusController;
use App\Http\Controllers\RegisterRefferalController;
use App\Http\Controllers\backoffice\BannerController;
use App\Http\Controllers\backoffice\DepositController;
use App\Http\Controllers\backoffice\GameAPIController;
use App\Http\Controllers\backoffice\PromosiController;
use App\Http\Controllers\backoffice\WithdrawController;
use App\Http\Controllers\backoffice\BackofficeController;
use App\Http\Controllers\backoffice\DatamemberController;
use App\Http\Controllers\backoffice\PernyataanController;
use App\Http\Controllers\backoffice\DepositbankController;
use App\Http\Controllers\backoffice\GameSettingController;
use App\Http\Controllers\backoffice\ProfilAdminController;
use App\Http\Controllers\backoffice\BannerPromosiController;
use App\Http\Controllers\backoffice\PengaturanSaldoController;
use App\Http\Controllers\backoffice\HistoritransaksiController;
use App\Http\Controllers\KycConctroller;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PaymentGatewayController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SgGameController;
use App\Http\Controllers\SlotController;
use App\Http\Controllers\OtpController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/activate', [ActivateController::class, 'index'])->name('activate.index');
Route::post('/activate', [ActivateController::class, 'activate'])->name('activate');


Route::get('/clear-cache', function () {
    $exitCode = Artisan::call('cache:clear');
    $exitCode = Artisan::call('config:cache');
    return 'DONE';
});

Route::post('/validate-email', [RegisterController::class, 'validateEmail'])->name('validate.email');
Route::post('/validate-name', [RegisterController::class, 'validateName'])->name('validate.name');
Route::post('/validate-password', [RegisterController::class, 'validatePassword'])->name('validate.password');
Route::post('/validate-passwordnot', [RegisterController::class, 'tidakSama'])->name('validate.passwordnot');

Route::get('/bersihkan-bukti', function () {
    Artisan::call('schedule:run');
    return 'Done';
});

Route::get('/list-transaksi', [DepositController::class, 'index'])->name('depo.tables');
Route::get('/list-members', [DataMemberController::class, 'index'])->name('data_member.index');
Route::get('/list-reff', [KycConctroller::class, 'listReff'])->name('data_reff.index');

Route::get('/notification', [NotificationController::class, 'index']);

#region user ( no login allowed )


Route::post('/verify-otp', [RegisterController::class, 'verifyOtp']);
Route::post('/resend-otp', [OtpController::class, 'resendOtp']);

Route::get('/', [HomeController::class, 'index'])->name('/');

Route::get('/add-provider', [AddGamecontroller::class, 'provider']);
Route::get('/add-games', [AddGameController::class, 'games']);
Route::get('/delete-games', [AddGameController::class, 'deleteGames']);
Route::get('/referral-register', [RefferalController::class, 'loadRefferal']);
Route::post('/referral-register/store', [RefferalController::class, 'store'])->name('store');

Route::get('/check-deposit-status', [UserDepositController::class, 'checkDepositStatus']);

Route::get('/promotion', function () {
    $banners = BannerPromosi::all();
    return view('promotion', compact('banners'));
});

Route::get('hot', [SgGameController::class, 'hot']);
Route::get('slots', [SgGameController::class, 'slot']);
Route::get('sports', [SgGameController::class, 'sports']);
Route::get('casino', [SgGameController::class, 'casino']);
Route::get('p2p', [SgGameController::class, 'p2p']);
Route::get('fishing', [SgGameController::class, 'fishing']);
Route::get('lottery', [SgGameController::class, 'lottery']);
Route::get('cockfight', [SgGameController::class, 'cockfight']);

Route::get('/complain-form', function () {
    return view('content.complain');
});


Route::get('/spxkid', function () {
    return view('slots.example');
});


// menu
Route::get('/memo', function () {
    return view('memo');
});

Route::get('/contact-us', function () {
    return view('contact-us');
});

Route::get('/complain', function () {
    return view('complain');
});

Route::get('/test', function () {
    $mc = new fiver();
    $act = $mc->agentbalance();
    print_r($act);
});

Route::get('/testasu', function () {
    $mcs = new wokakse();
    $act2 = $mcs->agentbalance();
    print_r($act2);
});

Route::get('/refferal', [RefferalController::class, 'index']);
Route::post('/getReferralDownline', [RefferalController::class, 'getReferralDownline']);

Route::get('/member-level', function () {
    return view('memberlevel');
});
Route::get('/keamanan', function () {
    return view('keamanan');
});

Route::post('/callback/qris', [QrisCallbackController::class, 'handle']);
Route::get('/support', [AdminLoginController::class, 'index']);
Route::POST('/support/login', [AdminLoginController::class, 'auth'])->name('admins.login');

Route::group(['middleware' => 'auth'], function () {
    Route::group(['middleware' => 'admin'], function () {
        Route::get('/get-balance', [BackofficeController::class, 'agentbalance']);
        Route::get('/get-balance2', [BackofficeController::class, 'agentbalance2']);
        Route::get('/total-bersih-harian', [BackofficeController::class, 'getTotalBersihHarian']);
        Route::resource('/deposit', DepositController::class);
        Route::resource('/withdraw', WithdrawController::class);
        Route::resource('/histori_transaksi', HistoritransaksiController::class);
        Route::resource('/dashboard', BackofficeController::class);
        Route::resource('/profil_admin', ProfilAdminController::class);
        Route::put('/user-deposit/aksi/{id}', [UserDepositController::class, 'action']);
        Route::POST('/deposit/{id}', [DepositController::class, 'update'])->name('transaksi.update');
        Route::put('/user-withdraw/aksi/{id}', [UserWithdrawController::class, 'aksi']);
        Route::resource('/pengaturan_saldo', PengaturanSaldoController::class);
        Route::post('/pengaturan_saldo/{id}/reject', [PengaturanSaldoController::class, 'reject'])->name('pengaturan_saldo.reject');
        Route::resource('/data_member', DatamemberController::class);
        Route::post('/data_member/create', [DatamemberController::class, 'create'])->name('create.member');
        Route::put('/data_member/update/{id}', [DatamemberController::class, 'update'])->name('update.member');
       	Route::post('/on/reff/{id}', [DatamemberController::class, 'onReff'])->name('on.reff');
       	Route::post('/off/reff/{id}', [DatamemberController::class, 'offReff'])->name('off.reff');
        Route::resource('/bank', DepositbankController::class);
        Route::resource('/inject-saldo', InjectController::class);
        Route::put('/saldo/update/{id}', [InjectController::class, 'update'])->name('saldo.update');
        Route::get('/update/saldo', [GetSaldoController::class, 'saldo']);
        Route::put('/deposit/reject/{id}', [DepositController::class, 'reject'])->name('depo.reject');
        Route::put('/deposit/confirm/{id}', [DepositController::class, 'confirm'])->name('depo.confirm');
        Route::put('/withdraw/reject/{id}', [WithdrawController::class, 'reject'])->name('withdraw.reject');
        Route::put('/withdraw/confirm/{id}', [WithdrawController::class, 'confirm'])->name('withdraw.confirm');
        
        Route::post('/update/pass', [ProfilAdminController::class, 'updatePassword'])->name('update.password');
        Route::put('/update/fonte', [SettingController::class, 'fonte'])->name('updateFonte');
        Route::put('/update/reff/{id}', [DatamemberController::class, 'updateReff'])->name('update.reff');

        Route::get('/kyc', [KycConctroller::class, 'index']);

        Route::put('/update/api/sg', [SettingController::class, 'apiSG'])->name('api.sg');
        Route::put('/update/api/nx', [SettingController::class, 'apiNX'])->name('api.nx');
        Route::put('/update/api/wsg', [SettingController::class, 'apiWSG'])->name('api.wsg');
        Route::put('/update/api/ng', [SettingController::class, 'apiNG'])->name('api.ng');
        Route::put('/update/api/ln', [SettingController::class, 'apiLN'])->name('api.ln');

        Route::get('/games', [GameController::class, 'games'])->name('games');
        Route::get('/providers', [GameController::class, 'providers'])->name('providers');
        Route::get('/other/providers', [GameController::class, 'otherProvider'])->name('other.providers');
        Route::delete('/providers/delete/{id}', [GameController::class, 'deleteProviders'])->name('delete.provider');

        
        Route::put('/providers/update/{id}', [GameController::class, 'updateProviders'])->name('update.provider');
        Route::put('/providers/other/{id}', [GameController::class, 'updateOtherProviders'])->name('update.other');
        
        Route::get('/downline/member/{id}',[DatamemberController::class, 'downlineShow'])->name('downline.member');
        Route::get('/downline/reff/{id}',[KycConctroller::class, 'reffShow'])->name('reff.data');

        Route::group(['middleware' => 'dev_mode'], function () {
            Route::get('/voucher-lucky-spin', [VoucherController::class, 'index']);
            Route::post('/generate-voucher', [VoucherController::class, 'generateVoucher']);
            Route::post('/fetch-game-history', [GameSettingController::class, 'getGameHistory'])->name('fetch.history');
            Route::get('/history-play/user', [GameSettingController::class, 'showForm']);
            Route::post('/call-list', [GameSettingController::class, 'callList']);
            Route::post('/call-apply', [GameSettingController::class, 'callApply']);
            Route::resource('/deposit_bank', DepositbankController::class);

            Route::resource('/pernyataan', PernyataanController::class);
            Route::resource('/banner', BannerController::class);
            Route::resource('/banner_promosi', BannerPromosiController::class);
            Route::resource('/bonus', BonusController::class);
            Route::resource('/game_setting', GameSettingController::class);
            Route::resource('/game_api', GameAPIController::class);
            Route::get('/game_setting_lock', [GameSettingController::class, 'lock']);
            Route::get('/game_setting_unlock', [GameSettingController::class, 'unlock']);

            Route::resource('/setting', SettingController::class);
            Route::put('/update/website', [SettingController::class, 'updateWebsite'])->name('update.website');
            Route::put('/update/contact', [SettingController::class, 'updateContact'])->name('update.contact');
            Route::put('/update/appearance', [SettingController::class, 'updateAppearance'])->name('update.appearance');
            Route::put('/update/popup', [SettingController::class, 'updatePopup'])->name('update.popup');
            Route::put('/update/gateway', [SettingController::class, 'updateGateway'])->name('update.gateway');
            Route::put('/update/depowd', [SettingController::class, 'updateWDDEPO'])->name('update.depowd');
            
        });
    });

    Route::post('/payment', [PaymentGatewayController::class, 'create'])->name('create-payment');
    Route::get('/payment/status', [PaymentGatewayController::class, 'statusPayment'])->name('status.payment');
    Route::get('/qrcode/show', function(Request $request) {
        $decodedUrl = base64_decode($request->encodedUrl);
        return redirect($decodedUrl);
    })->name('qrcode.show');
    Route::get('/payment/qris', [PaymentGatewayController::class, 'paymentQris'])->name('bayar.qris');

    // ROUTE USER
    Route::GET('/profile', [ProfileController::class, 'index']);
    Route::POST('/turnover', [TurnoverController::class, 'turnOver']);
    Route::GET('/turnoveruser', [TurnoverController::class, 'turnOverAdmin']);
    Route::GET('/promo/saya', [TurnoverController::class, 'index']);
    Route::POST('/promo/bonus', [TurnoverController::class, 'getBonusPromotion']);
    Route::resource('/account/deposit', UserDepositController::class);
    Route::get('/account/withdrawal', [UserWithdrawController::class, 'index']);
    Route::POST('/withdrawal/user', [UserWithdrawController::class, 'store']);
    Route::get('/wdcuy', [UserWithdrawController::class, 'WD']);
    Route::resource('/account/lastDirectTransfer', UserHistoryController::class);
    Route::resource('/account/history', UserPernyataanController::class);

    Route::get('games/server-a/{provider_code}', [GameController::class, 'slotShow']);
    Route::get('games/server-b/{provider_code}/{provider_type}', [GameController::class, 'slotShow']);

    Route::post('/validate-voucher', [SpinController::class, 'validateVoucher']);
    Route::get('/spin', [SpinController::class, 'index']);
    Route::POST('/save-prize', [SpinController::class, 'spinPrize']);

    Route::get('/activate-refferal', [HomeController::class, 'activateRefferal']);
    Route::get('/saldo-refresh', [HomeController::class, 'saldoRefresh'])->name('saldo-refresh');

    Route::get('/ajaxprofileEdit', function () {
        return view('profile_edit');
    });

    Route::get('/ajaxchgPass', function () {
        return view('change_password');
    });

    Route::get('/masuk', function () {
    return back()->with('error', 'Silahkan login dengan akun anda!');
    });

    Route::get('/getBal', function () {
        return view('get_balance');
    });
    Route::get('/ajaxIDNBal', function () {
        return view('get_balance');
    });

    Route::GET('/search-history', [RefferalController::class, 'searchHistory']);
    Route::GET('/search-history-today', [RefferalController::class, 'getTodaReff']);
});

Route::get('/game_process/{game_code}/{game_provider}', [GameController::class, 'connect_games']);
Route::get('/game_process2/{game:id}', [GameController::class, 'connect_games2']);
Route::get('/handle-game/{server}/{game}', [GameController::class, 'handleProvider'])->name('handle-game');

Auth::routes();
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');



