<?php $__env->startSection('content'); ?>
    <div class="container">
        <h2 class="title">Referral Downline</h2>
        <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdn.sitestatic.net/assets/daterangepicker/daterangepicker.css">
        <form id="searchhistory" class="needs-validation searchhistory" novalidate="novalidate">
            <div class="box-wrapper plr-15">
                <div class="row d-flex align-items-center">
                    <div class="col-md-3 col-xs-4 ">
                        <div class="">
                            Tanggal </div>
                    </div>
                    <div class="col-md-9 col-xs-8 d-flex flex-wrap">
                        <input type="text" class="form-control datepicker m-15 has-feedback has-success" name="daterange"
                            aria-describedby="daterange-error"><i
                            class="form-control-feedback absolute m-15 icon-checkmark"></i><em id="daterange-error"
                            class="error help-block mlr-15"></em>
                        <div class="m-15">
                            <small>Catatan : Rentang tanggal pencarian dibatasi hingga 30 hari.</small>
                        </div>
                    </div>
                </div>
            </div>

        </form>
        <script type="text/javascript" src="https://cdn.sitestatic.net/assets/daterangepicker/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.sitestatic.net/assets/daterangepicker/daterangepicker.min.js"></script>
        <script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" type="text/javascript"></script>

        <script src="https://cdn.sitestatic.net/assets/jquery-validation/jquery.validate.min.js"></script>
        <script src="https://cdn.sitestatic.net/assets/jquery-validation/additional-methods.min.js"></script>
        <script>
            $(document).ready(function() {
                var start = moment().subtract(30, 'days'),
                    end = moment(),
                    last2 = moment().subtract(2, 'days'),
                    last3 = moment().subtract(3, 'days');
                $('input[name="daterange"]').on('cancel.daterangepicker', function(ev, picker) {
                    $(this).val('');
                });

                function cb(start, end) {
                    $('.datepicker').html(start.format('YYYY/MM/DD') + ' - ' + end.format('YYYY/MM/DD'));
                }

                $('.datepicker').on('click', function(e) {
                    e.preventDefault();
                    $(this).attr("autocomplete", "off");
                });

                $('.datepicker').daterangepicker({
                    locale: {
                        format: 'YYYY/MM/DD',
                        cancelLabel: 'Clear',
                        customRangeLabel: "Custom Range",
                    },
                    startDate: start,
                    endDate: end,
                    ranges: {
                        "Hari ini": [moment(), moment()],
                        "Kemarin": [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        "7 Hari Terakhir": [moment().subtract(6, 'days'), moment()],
                        "30 hari terakhir": [moment().subtract(29, 'days'), moment()],
                        "Bulan ini": [moment().startOf('month'), moment().endOf('month')],
                        "Bulan lalu": [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                            'month').endOf('month')]
                    }
                }, cb);
                cb(start, end);

                $("#searchhistory").validate({
                    rules: {

                        daterange: {
                            required: true,

                        }
                    },
                    // Specify validation error messages
                    messages: {
                        daterange: {
                            required: "lang.cant be empty",
                        },
                    },
                    errorElement: "em",
                    errorPlacement: function(error, element) {
                        // Add the `help-block` class to the error element
                        error.addClass("help-block mlr-15");
                        // Add `has-feedback` class to the parent div.form-group
                        // in order to add icons to inputs
                        //element.parents(".col-sm-6").addClass("has-feedback");
                        element.addClass("has-feedback");
                        if (element.prop("type") === "checkbox") {
                            error.insertAfter(element.parent("label"));
                        } else {
                            error.insertAfter(element);
                        }

                        // Add the span element, if doesn't exists, and apply the icon classes to it.
                        if (!element.next("i")[0]) {
                            $("<i class='icon-cancel form-control-feedback absolute m-15'></i>")
                                .insertAfter(element);
                        }
                    },
                    success: function(label, element) {
                        // Add the span element, if doesn't exists, and apply the icon classes to it.

                        if (!$(element).next("i")[0]) {
                            $("<i class='icon-checkmark  form-control-feedback absolute m-15'></i>")
                                .insertAfter($(element));
                        }
                    },
                    highlight: function(element, errorClass, validClass) {
                        $(element).addClass("has-error").removeClass("has-success");
                        $(element).next("i").addClass("icon-cancel").removeClass("icon-checkmark");
                    },
                    unhighlight: function(element, errorClass, validClass) {
                        $(element).addClass("has-success").removeClass("has-error");
                        $(element).next("i").addClass("icon-checkmark").removeClass("icon-cancel");
                    },
                    submitHandler: function(form) {
                        $('#historySearchResult').html('');
                        $('button[type=submit]').prop('disabled', false);
                        $.post('https://cumidarat69.com/getReferralDownline', $('#searchhistory')
                            .serialize(),
                            function(data) {
                                $('button[type=submit]').prop('disabled', false);
                                $('button[type=submit]').removeClass("disabled");

                                $('#historySearchResult').html(data);

                                $('#referral-table').on('draw.dt', function() {
                                    convertToLocalDate();
                                });

                                convertToLocalDate();
                            });
                    }
                });

                function convertToLocalDate() {
                    $('.js-date').each(function(i) {
                        var dt = $(this).text().trim();
                        var isutc = $(this).hasClass('isutc');

                        if (isutc) {

                            if (dt && dt != '-') {

                                if (dt[dt.length - 1] != 'Z') {
                                    dt = dt + 'Z';
                                }
                                $(this).text(moment.utc(dt).local().format("YYYY-MM-DD | HH:mm:ss"));
                                $(this).removeClass('isutc');
                            }
                        }
                    });
                }
                $('#referral-table').on('draw.dt', function() {
                    convertToLocalDate();
                });
                convertToLocalDate();
            });
        </script>
        <div class="mt-2" id="historySearchResult">
            <div class="col-md-12">
                <div id="historySearchResult" class="m-tb-15">
                    <div id="referral-table_wrapper" class="dataTables_wrapper no-footer">
                        <div class="dataTables_length" id="referral-table_length"><label>Menampilkan <select
                                    name="referral-table_length" aria-controls="referral-table" class="">
                                    <option value="10">10</option>
                                    <option value="25">25</option>
                                    <option value="50">50</option>
                                    <option value="100">100</option>
                                </select> entri</label></div>
                        <table
                            class="table table-bordered table-hover toggle-circle dataTable no-footer table-striped table-responsive"
                            id="referral-table" role="grid" aria-describedby="referral-table_info">
                            <thead>
                                <tr role="row">
                                    <th class="sorting_asc" tabindex="0" aria-controls="referral-table" rowspan="1"
                                        colspan="1" style="width: 23.65px;" aria-sort="ascending"
                                        aria-label="No.: activate to sort column descending">No.</th>
                                    <th class="sorting" tabindex="0" aria-controls="referral-table" rowspan="1"
                                        colspan="1" style="width: 87.8667px;"
                                        aria-label="Nama pengguna: activate to sort column ascending">Nama
                                        pengguna</th>
                                    <th class="sorting" tabindex="0" aria-controls="referral-table" rowspan="1"
                                        colspan="1" style="width: 81.75px;"
                                        aria-label="Tanggal Bergabung: activate to sort column ascending">
                                        Tanggal Bergabung</th>
                                    <th class="sorting" tabindex="0" aria-controls="referral-table" rowspan="1"
                                        colspan="1" style="width: 63.1667px;"
                                        aria-label="Tanggal Terakhir Login: activate to sort column ascending">
                                        Tanggal Terakhir Login</th>
                                    <th class="sorting" tabindex="0" aria-controls="referral-table" rowspan="1"
                                        colspan="1" style="width: 62.4667px;"
                                        aria-label="Tanggal Setoran Pertama: activate to sort column ascending">
                                        Tanggal Setoran Pertama</th>
                                    <th class="sorting" tabindex="0" aria-controls="referral-table" rowspan="1"
                                        colspan="1" style="width: 60.35px;"
                                        aria-label="Tanggal Terakhir Deposit: activate to sort column ascending">
                                        Tanggal Terakhir Deposit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $downlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr role="row" class="odd">
                                        <td class="sorting_1"><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($downline->name); ?></td>
                                        <td><?php echo e($downline->created_at->format('d-m-Y | H:i:s')); ?></td>
                                        <td>-</td>
                                        <td>
                                            <?php if($downline->first_deposit_date): ?>
                                                <?php echo e($downline->first_deposit_date->format('d-m-Y | H:i:s')); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>-</td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <script>
                            $('#referral-table').DataTable({
                                language: {
                                    lengthMenu: "Menampilkan _MENU_ entri",
                                    sSearch: "Cari Pesan Disini",
                                    sEmptyTable: "Tidak ada data yang tersedia",
                                    sInfoEmpty: "Menampilkan 0 hingga 0 dari 0 entri",
                                    sInfo: "Menampilkan _START_ hingga _END_ dari _TOTAL_ entri",
                                    sInfoFiltered: "(disaring dari _MAX_ total entri)",
                                    oPaginate: {
                                        sFirst: "Pertama",
                                        sLast: "Terakhir",
                                        sNext: "Lanjut",
                                        sPrevious: "Sebelumnya"
                                    },
                                },
                                responsive: true
                            });
                        </script>

                    </div>
                </div>
            </div>
        </div>
        <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js" type="text/javascript"></script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/onWeb/dosmon99.com/resources/views/refferal.blade.php ENDPATH**/ ?>