<?php $__env->startSection('content'); ?>
    <div class="pt-3">
        <h4>Info Downline Member</h4>
    </div>

    <?php if(Session::has('success')): ?>
        <script type="text/javascript">
            Swal.fire(
                'Berhasil',
                '<?php echo e(Session::get('success')); ?>',
                'success'
            );
        </script>
    <?php endif; ?>
    <?php if(Session::has('error')): ?>
        <script type="text/javascript">
            Swal.fire(
                'Warning',
                '<?php echo e(Session::get('error')); ?>',
                'error'
            );
        </script>
    <?php endif; ?>

    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <!-- Sidebar Member Info -->
                <div class="col-md-3">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <img class="profile-user-img img-fluid img-circle"
                                    src="https://adminlte.io/themes/v3/dist/img/user4-128x128.jpg"
                                    alt="User profile picture">
                                <div class="profile-username text-center"><?php echo e($user->name); ?></div>
                                <ul class="list-group list-group-unbordered mb-3">
                                    <li class="list-group-item">
                                        <b>Tgl Register : </b>
                                        <a class="float-right"><?php echo e($user->created_at->format('d-m-Y')); ?></a>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Total Downline : </b>
                                        <a class="float-right"><?php echo e($totalDownline); ?> Member</a>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Total DP Member </b>
                                        <a class="float-right">Rp <?php echo e(number_format($totalFirstDeposit, 0, ',', '.')); ?></a>
                                    </li>
                                </ul>
                                <button data-toggle="modal" data-target="#delete<?php echo e($user->id); ?>"
                                    data-member="<?php echo e(json_encode($user)); ?>" type="button"
                                    class="btn btn-danger btn-block"><i class="fas fa-trash"></i> Delete</button>
                                <div class="modal fade" id="delete<?php echo e($user->id); ?>" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="<?php echo e(route('data_member.destroy', $user->id)); ?>" method="POST"
                                                enctype="multipart/form-data">
                                                <?php echo e(csrf_field()); ?>

                                                <?php echo method_field('DELETE'); ?>
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Hapus Data Member</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Apakah anda yakin akan manghapus data member ?
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger">Hapus Data</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <p>
                                    <?php if($user->email_verified_at): ?>
                                        <?php if($user->status_reff == 0): ?>
                                            <form action="<?php echo e(route('on.reff', ['id' => $user->id])); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="reff_status" value="1">
                                                <button type="submit" class="btn btn-primary btn-block">Konfirmasi
                                                    Reff</button>
                                            </form>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('off.reff', ['id' => $user->id])); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="reff_status" value="0">
                                                <button type="submit" class="btn btn-warning btn-block">Nonaktifkan
                                                    Reff</button>
                                            </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab Content (Right Side) -->
                <div class="col-md-9">
                    <div class="card">
                        <div class="card-header p-2">
                            <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                                <!-- Tab Downline -->
                                <li class="nav-item" style="margin-right: 5px">
                                    <a class="nav-link active" id="downline-tab" data-toggle="pill" href="#downline"
                                        role="tab" aria-controls="downline" aria-selected="true">Downline</a>
                                </li>
                                <!-- Tab Update -->
                                <li class="nav-item" style="margin-right: 5px">
                                    <a class="nav-link" id="update-tab" data-toggle="pill" href="#update" role="tab"
                                        aria-controls="update" aria-selected="false">Update</a>
                                </li>
                                <li class="nav-item" style="margin-right: 5px">
                                    <a class="nav-link" id="reff-tab" data-toggle="pill" href="#reff" role="tab"
                                        aria-controls="reff" aria-selected="false">Reff</a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content" id="custom-tabs-three-tabContent">
                                <!-- Tab Downline Content -->
                                <div class="tab-pane fade active show" id="downline" role="tabpanel"
                                    aria-labelledby="downline-tab">
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th>Username</th>
                                                <th>Tgl Daftar</th>
                                                <th>Deposit Pertama</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $downlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($downline->name); ?></td>
                                                    <td><?php echo e($downline->created_at->format('d-m-Y')); ?></td>
                                                    <td>
                                                        <?php echo e(isset($deposits[$downline->name]) ? $deposits[$downline->name] : 0); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Tab Update Content -->
                                <div class="tab-pane fade" id="update" role="tabpanel" aria-labelledby="update-tab">
                                    <form action="<?php echo e(route('update.member', $user->id)); ?>" method="POST"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="form-group">
                                            <label for="nama">Username</label>
                                            <input id="nama" type="text" class="form-control" name="nama"
                                                value="<?php echo e($user->name); ?>" required pattern="^\S+$"
                                                title="Username tidak boleh mengandung spasi.">
                                        </div>
                                        <div class="form-group">
                                            <label for="password">Password</label>
                                            <input id="password" type="password" class="form-control" name="password"
                                                value="">
                                        </div>
                                        <div class="form-group">
                                            <label for="email">Email</label>
                                            <input id="email" type="email" class="form-control" name="email"
                                                value="<?php echo e($user->email); ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="telp">Whatsapp</label>
                                            <input id="telp" type="number" class="form-control" name="telp"
                                                value="<?php echo e($user->telp); ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="ref_code">Reff Code</label>
                                            <input id="ref_code" type="text" class="form-control" name="ref_code"
                                                value="<?php echo e($user->ref_code); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="nama_rek">Nama Rek</label>
                                            <input id="nama_rek" type="text" class="form-control" name="nama_rek"
                                                value="<?php echo e($user->nama_rek); ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="bank">Bank</label>
                                            <select id="bank" name="bank" class="form-control" required>
                                                <option value="">- Silahkan pilih -</option>
                                                <option value="BCA" <?php echo e($user->bank == 'BCA' ? 'selected' : ''); ?>>Bank
                                                    Central Asia (BCA)</option>
                                                <option value="Mandiri" <?php echo e($user->bank == 'Mandiri' ? 'selected' : ''); ?>>
                                                    Bank Mandiri</option>
                                                <option value="BRI" <?php echo e($user->bank == 'BRI' ? 'selected' : ''); ?>>Bank
                                                    Rakyat Indonesia (BRI)</option>
                                                <option value="BNI" <?php echo e($user->bank == 'BNI' ? 'selected' : ''); ?>>Bank
                                                    Negara Indonesia (BNI)</option>
                                                <option value="BSI" <?php echo e($user->bank == 'BSI' ? 'selected' : ''); ?>>Bank
                                                    Syariah Indonesia (BSI)</option>
                                                <option value="Seabank" <?php echo e($user->bank == 'Seabank' ? 'selected' : ''); ?>>
                                                    Seabank</option>
                                                <option value="CIMB" <?php echo e($user->bank == 'CIMB' ? 'selected' : ''); ?>>CIMB
                                                    Niaga</option>
                                                <option value="BTN" <?php echo e($user->bank == 'BTN' ? 'selected' : ''); ?>>Bank
                                                    Tabungan Negara (BTN)</option>
                                                <option value="Danamon" <?php echo e($user->bank == 'Danamon' ? 'selected' : ''); ?>>
                                                    Bank Danamon</option>
                                                <option value="Permata" <?php echo e($user->bank == 'Permata' ? 'selected' : ''); ?>>
                                                    Bank Permata</option>
                                                <option value="OCBC" <?php echo e($user->bank == 'OCBC' ? 'selected' : ''); ?>>OCBC
                                                    NISP</option>
                                                <option value="Mega" <?php echo e($user->bank == 'Mega' ? 'selected' : ''); ?>>Bank
                                                    Mega</option>
                                                <option value="Maybank" <?php echo e($user->bank == 'Maybank' ? 'selected' : ''); ?>>
                                                    Maybank Indonesia</option>
                                                <option value="Panin" <?php echo e($user->bank == 'Panin' ? 'selected' : ''); ?>>Bank
                                                    Panin</option>
                                                <option value="BTPN" <?php echo e($user->bank == 'BTPN' ? 'selected' : ''); ?>>Bank
                                                    BTPN</option>
                                                <option value="Commonwealth"
                                                    <?php echo e($user->bank == 'Commonwealth' ? 'selected' : ''); ?>>Bank Commonwealth
                                                </option>
                                                <option value="Sinarmas"
                                                    <?php echo e($user->bank == 'Sinarmas' ? 'selected' : ''); ?>>Bank Sinarmas
                                                </option>
                                                <option value="Bukopin" <?php echo e($user->bank == 'Bukopin' ? 'selected' : ''); ?>>
                                                    Bank Bukopin</option>
                                                <option value="Mestika" <?php echo e($user->bank == 'Mestika' ? 'selected' : ''); ?>>
                                                    Bank Mestika</option>
                                                <option value="Woori Saudara"
                                                    <?php echo e($user->bank == 'Woori Saudara' ? 'selected' : ''); ?>>Bank Woori
                                                    Saudara</option>
                                                <option value="MNC" <?php echo e($user->bank == 'MNC' ? 'selected' : ''); ?>>Bank
                                                    MNC</option>
                                                <option value="BJB" <?php echo e($user->bank == 'BJB' ? 'selected' : ''); ?>>Bank
                                                    Jawa Barat dan Banten (BJB)</option>
                                                <option value="BPD Bali"
                                                    <?php echo e($user->bank == 'BPD Bali' ? 'selected' : ''); ?>>Bank Pembangunan
                                                    Daerah Bali</option>
                                                <option value="BPD Jatim"
                                                    <?php echo e($user->bank == 'BPD Jatim' ? 'selected' : ''); ?>>Bank Pembangunan
                                                    Daerah Jawa Timur (BPD Jatim)</option>
                                                <option value="BPD Jateng"
                                                    <?php echo e($user->bank == 'BPD Jateng' ? 'selected' : ''); ?>>Bank Pembangunan
                                                    Daerah Jawa Tengah (BPD Jateng)</option>
                                                <option value="BPD DIY" <?php echo e($user->bank == 'BPD DIY' ? 'selected' : ''); ?>>
                                                    Bank Pembangunan Daerah DIY</option>
                                                <option value="BPD Sumut"
                                                    <?php echo e($user->bank == 'BPD Sumut' ? 'selected' : ''); ?>>Bank Sumut</option>
                                                <option value="BPD Aceh"
                                                    <?php echo e($user->bank == 'BPD Aceh' ? 'selected' : ''); ?>>Bank Aceh</option>
                                                <option value="BPD Sulselbar"
                                                    <?php echo e($user->bank == 'BPD Sulselbar' ? 'selected' : ''); ?>>Bank Sulawesi
                                                    Selatan dan Barat (BPD Sulselbar)</option>
                                                <option value="BPD Kalbar"
                                                    <?php echo e($user->bank == 'BPD Kalbar' ? 'selected' : ''); ?>>Bank Kalimantan
                                                    Barat (BPD Kalbar)</option>
                                                <option value="BPD Kaltimtara"
                                                    <?php echo e($user->bank == 'BPD Kaltimtara' ? 'selected' : ''); ?>>Bank Kaltimtara
                                                </option>
                                                <option value="BPD Sumsel Babel"
                                                    <?php echo e($user->bank == 'BPD Sumsel Babel' ? 'selected' : ''); ?>>Bank Sumsel
                                                    Babel</option>
                                                <option value="">- Silahkan pilih E-Wallet -</option>
                                                <option value="GoPay" <?php echo e($user->bank == 'GoPay' ? 'selected' : ''); ?>>
                                                    GoPay</option>
                                                <option value="OVO" <?php echo e($user->bank == 'OVO' ? 'selected' : ''); ?>>OVO
                                                </option>
                                                <option value="DANA" <?php echo e($user->bank == 'DANA' ? 'selected' : ''); ?>>DANA
                                                </option>
                                                <option value="LinkAja" <?php echo e($user->bank == 'LinkAja' ? 'selected' : ''); ?>>
                                                    LinkAja</option>
                                                <option value="ShopeePay"
                                                    <?php echo e($user->bank == 'ShopeePay' ? 'selected' : ''); ?>>ShopeePay</option>
                                                <option value="SakuKu" <?php echo e($user->bank == 'SakuKu' ? 'selected' : ''); ?>>
                                                    Sakuku</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="no_rek">No Rek</label>
                                            <input id="no_rek" type="number" class="form-control" name="no_rek"
                                                value="<?php echo e($user->no_rek); ?>" required>
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-block">Update</button>
                                    </form>
                                </div>
                                <div class="tab-pane fade" id="reff" role="tabpanel" aria-labelledby="reff-tab">
                                    <form action="<?php echo e(route('update.reff', $user->id)); ?>" method="POST"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="form-group">
                                            <label for="nama">Refferal Parent ID</label>
                                            <select class="form-control" name="parent_id" id="">
                                                <option value="">- Silahkan pilih Refferal Parent ID -</option>
                                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($u->id); ?>" <?php echo e($u->id == $refferal ? 'selected' : ''); ?>>
                                                        <?php echo e($u->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-block">Update</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alladin303.xyz/public_html/resources/views/admin/data_member/downline_member.blade.php ENDPATH**/ ?>