<?php

use Illuminate\Support\Facades\Auth;

$user_level = Auth::user()->level;
$is_developer = (int) $user_level === 2;
$is_admin = (int) $user_level <= 2;

?>


<?php $__env->startSection('content'); ?>
    <div class="card mt-3">
        <div class="card-header">
            <button id="generate-voucher-btn">Generate Voucher</button>
            <p style="color: black" id="voucher-code-display"></p>
        </div>

        <div class="card-header">

        </div>

        <div class="card-body">
            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th scope="col">Tanggal</th>
                        <th>Code</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $Voucher; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($Voucher->created_at); ?></td>
                            <td><?php echo e($Voucher->code); ?></td>
                            <?php if($Voucher->is_valid == true): ?>
                                <td>Belum Terpakai</td>
                            <?php else: ?>
                                <td>Sudah Terpakai</td>
                            <?php endif; ?>
                            <td></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#generate-voucher-btn').click(function() {
                $.ajax({
                    url: '/generate-voucher',
                    type: 'POST',
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(data) {
                        $('#voucher-code-display').text('Generated Voucher Code: ' + data
                            .voucher_code);
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error: ' + status + ' ' + error);
                    }
                });
            });
        });

        $('#example2').DataTable({
            paging: true,
            lengthChange: true,
            searching: true,
            ordering: true,
            info: true,
            autoWidth: false,
            responsive: true,
            order: [
                [1, 'desc']
            ],
            bState: false,
            bAutoWidth: false,
            data: datatables_data,
            aoColumns: [{
                    sWidth: '5%',
                    mData: 'iteration'
                },
                {
                    sWidth: '5%',
                    mData: 'created_at'
                },
                {
                    sWidth: '15%',
                    mData: 'username'
                },
                {
                    sWidth: '8%',
                    mData: 'rekening'
                },
                {
                    sWidth: '8%',
                    mData: 'bank'
                },
                {
                    sWidth: '10%',
                    mData: 'nominal'
                },
                {
                    sWidth: '8%',
                    mData: 'bonus'
                },
                {
                    sWidth: '10%',
                    mData: 'keterangan'
                },
                {
                    sWidth: '5%',
                    mData: "id",
                    mRender: render_transfer
                },
                {
                    sWidth: '10%',
                    mData: "id",
                    mRender: render_action
                }

            ]
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alladin303.xyz/public_html/resources/views/admin/kode/generate_kode.blade.php ENDPATH**/ ?>