<?php
use App\Models\Setting;

$setting = Setting::first();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($setting->nama_web); ?> : Dashboard Panel</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/fontawesome-free/css/all.min.css')); ?>">
    
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet"
        href="<?php echo e(asset('/../../Admin/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
    <!-- iCheck -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/dist/css/adminlte.min.css')); ?>">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/daterangepicker/daterangepicker.css')); ?>">
    <!-- summernote -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/summernote/summernote-bs4.min.css')); ?>">
    <script src="https://kit.fontawesome.com/c0adac4be5.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lazysizes/5.3.0/lazysizes.min.js" async></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(asset('/../../Admin/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(asset('/../../Admin/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
    <!-- jQuery -->
    <script src="<?php echo e(asset('/../../Admin/plugins/jquery/jquery.min.js')); ?>"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="<?php echo e(asset('/../../Admin/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
    <!-- Custom style -->
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/css/backoffice.css')); ?>">
    <link rel="icon" href="<?php echo e(asset('/../../Admin/image/NYOBAINmini.png')); ?>" type="image/gif">


</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        <?php echo $__env->make('admin.layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">

                    <?php echo $__env->yieldContent('content'); ?>

                </div><!-- /.container-fluid -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->
        <footer class="main-footer">
            <strong>
                <!-- --> &copy; 2024 <a href="#"><?php echo e($setting->nama_web); ?></a>.
            </strong>
            <?php echo e($setting->seo_description); ?>


            <div class="float-right d-none d-sm-inline-block">
                <script>
                    document.write(unescape(
                        '%3C%61%20%68%72%65%66%3D%22%68%74%74%70%73%3A%2F%2F%74%2E%6D%65%2F%76%65%6C%69%74%61%32%32%22%20%73%74%79%6C%65%3D%22%64%69%73%70%6C%61%79%3A%20%62%6C%6F%63%6B%3B%20%74%65%78%74%2D%61%6C%69%67%6E%3A%20%63%65%6E%74%65%72%3B%20%77%69%64%74%68%3A%20%31%30%30%25%3B%20%63%6F%6C%6F%72%3A%20%23%39%62%39%62%39%62%3B%20%74%65%78%74%2D%73%68%61%64%6F%77%3A%20%30%70%78%20%30%70%78%20%34%70%78%20%72%67%62%61%28%30%2C%20%30%2C%20%30%2C%20%30%2E%35%29%3B%20%74%65%78%74%2D%64%65%63%6F%72%61%74%69%6F%6E%3A%20%6E%6F%6E%65%3B%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%26%23%31%36%39%3B%20%48%53%54%65%61%6D%20%44%65%76%65%6C%6F%70%65%72%20%26%23%31%37%34%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2F%61%3E'
                        ));
                </script>
            </div>
        </footer>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>
    <!-- ./wrapper -->

    <!-- jQuery -->
    <script src="<?php echo e(asset('/../../Admin/plugins/jquery/jquery.min.js')); ?>"></script>
    <script type="text/javascript" src="https://code.jquery.com/jquery-2.2.4.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="<?php echo e(asset('/../../Admin/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button)
    </script>
    <!-- Bootstrap 4 -->
    <script src="<?php echo e(asset('/../../Admin/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- jQuery Knob Chart -->
    <script src="<?php echo e(asset('/../../Admin/plugins/jquery-knob/jquery.knob.min.js')); ?>"></script>
    <!-- daterangepicker -->
    <script src="<?php echo e(asset('/../../Admin/plugins/moment/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
    <!-- Tempusdominus Bootstrap 4 -->
    <script src="<?php echo e(asset('/../../Admin/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>">
    </script>
    <!-- Summernote -->
    <script src="<?php echo e(asset('/../../Admin/../../Admin/../../Admin/plugins/summernote/summernote-bs4.min.js')); ?>"></script>
    <!-- overlayScrollbars -->
    <script src="<?php echo e(asset('/../../Admin/../../Admin/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>">
    </script>
    <!-- AdminLTE App -->
    <script src="<?php echo e(asset('/../../Admin/dist/js/adminlte.js')); ?>"></script>
    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
    <script src="<?php echo e(asset('/../../Admin/dist/js/pages/dashboard.js')); ?>"></script>
    <link rel="stylesheet" href="https://cdn.ckeditor.com/ckeditor5/43.0.0/ckeditor5.css" />
    <!-- DataTables  & Plugins -->
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/../../Admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/pdfmake/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>

    <script>
        let lastSoundTime = 0;

        setInterval(function() {
            $.ajax({
                url: '/check-deposit-status',
                method: 'GET',
                success: function(response) {
                    if (response.newDeposit) {
                        let currentTime = new Date().getTime();
                        if (currentTime - lastSoundTime >= 5000) {
                            var audio = new Audio('/sounds/notification.mp3');
                            audio.play();

                            lastSoundTime = currentTime;
                        }
                        const toastHTML = `
                            <div class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-autohide="true" style="min-width: 200px;">
                                <div class="toast-header">
                                    <strong class="me-auto">Notifikasi Deposit</strong>
                                    <small>${new Date().toLocaleTimeString()}</small>
                                </div>
                                <div class="toast-body">
                                    Deposit baru terdeteksi dari user ID: ${response.user_id} sebesar ${response.nominal}!
                                </div>
                            </div>
                        `;
                        $('#toast-container').append(toastHTML);
                        $('.toast').last().toast('show');
                    }
                },
                error: function() {
                    console.log('Error saat cek status deposit');
                }
            });
        }, 1000);
    </script>

    <script>
        $(document).ready(function() {
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": true,
                "responsive": true,
            });

        });
    </script>
    <script type="importmap">
        {
            "imports": {
                "ckeditor5": "https://cdn.ckeditor.com/ckeditor5/43.0.0/ckeditor5.js",
                "ckeditor5/": "https://cdn.ckeditor.com/ckeditor5/43.0.0/"
            }
        }
    </script>

    <script type="module">
        import {
            ClassicEditor,
            Essentials,
            Bold,
            Italic,
            Font,
            Paragraph
        } from 'ckeditor5';

        ClassicEditor
            .create(document.querySelector('#editor'), {
                plugins: [Essentials, Bold, Italic, Font, Paragraph],
                toolbar: {
                    items: [
                        'undo', 'redo', '|', 'bold', 'italic', '|',
                        'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor'
                    ]
                }
            })
            .then( /* ... */ )
            .catch( /* ... */ );
    </script>

</body>

</html>
<?php /**PATH /www/wwwroot/dokmil88.com/resources/views/admin/layouts/main.blade.php ENDPATH**/ ?>