<?php
use App\Models\Saldo;
use App\Http\Api\fiver;
?>

<?php if(auth()->guard()->check()): ?>
    <?php
        $SG = new fiver();
        $act = json_decode($SG->userbalance(Auth()->user()->name));
        $saldos = $act->user->balance ?? '0';
    ?>
    <button class="btn btn-link enlarge wallet">
        <i class="icon-wallet"></i>
        <span class="bal-txt">IDR <?php echo number_format($saldos,2); ?></span>
        <a class="btn btn-clear btn-refresh-loadball btn-wallet-load pull-right"><i class="icon-refresh-2"></i></a>
    </button>
    <style>
        .btn-wallet-load {
            width: 29px !important;
            padding-left: 2px !important;
        }

        .icon-spin {
            animation: rotation 1s infinite linear;
        }

        @keyframes rotation {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(359deg);
            }
        }
    </style>
    <script>
        $(function() {
            $(document).on('click', '.btn-wallet-load', function(e) {
                e.preventDefault();

                $('.btn-wallet-load').addClass('icon-spin');
                const url = "<?php echo e(URL::to('saldo-refresh')); ?>";
                $.get(url, function(data) {
                    $('.btn-wallet-load').removeClass('icon-spin');
                    let datas = JSON.parse(data);
                    if (datas.error === false) {
                        $('.bal-txt').text('IDR ' + datas.balance.toString().replace(
                            /\B(?=(\d{3})+(?!\d))/g, ",") + '.00');
                    }
                })
            })
        })
    </script>
<?php endif; ?>
<?php /**PATH /www/wwwroot/runningWeb/japarplay.biz.id/resources/views/content/navdesktop.blade.php ENDPATH**/ ?>