<?php if(!app('mobile-detect')->isMobile()) : ?>
    <?php $__env->startSection('desktop'); ?>
        <style>
            .progress-container {
                width: 100%;
                background-color: #e0e0e0;
                border-radius: 5px;
                overflow: hidden;
            }

            .progress-bar {
                height: 20px;
                background-color: #76c7c0;
                width: 0;
                border-radius: 5px;
            }
        </style>
        <div class="content my01">
            <div class="container my_promo_view">
                <div class="container-wrapper profile-head">
                    <div class="container container-box noSidePadding">
                        <div class="title fs-lg clearfix">
                            <span class="skew">
                                <span>Promo saya</span>
                            </span>
                        </div>
                        <div class="head-content">
                            <div class="row no-gutters">
                                <div class="col-xs-12">
                                    <div class="mdc-tab-bar" role="tablist">
                                        <div class="mdc-tab-scroller">
                                            <div class="mdc-tab-scroller__scroll-area mdc-tab-scroller__scroll-area--scroll"
                                                style="margin-bottom: 0px;">
                                                <div class="mdc-tab-scroller__scroll-content">
                                                    <a role="tab" href="#" data-tabname="my-promo-new"
                                                        data-active="promomy-promo-new" class="mdc-tab mdc-tab--active-new"
                                                        aria-selected="true" tabindex="0">
                                                        <span class="mdc-tab__content">
                                                            <span class="mdc-tab__text-label">Promo saya</span>
                                                        </span>
                                                        <span class="mdc-tab-indicator mdc-tab-indicator--active">
                                                            <span
                                                                class="mdc-tab-indicator__content mdc-tab-indicator__content--underline"></span>
                                                        </span>
                                                        <span class="mdc-tab__ripple mdc-ripple-upgraded"></span>
                                                    </a>
                                                    <a role="tab" href="#" data-tabname="my-bonus-new"
                                                        data-active="promomy-bonus-new" class="mdc-tab" aria-selected="false"
                                                        tabindex="-1">
                                                        <span class="mdc-tab__content">
                                                            <span class="mdc-tab__text-label">Bonus saya</span>
                                                        </span>
                                                        <span class="mdc-tab-indicator">
                                                            <span
                                                                class="mdc-tab-indicator__content mdc-tab-indicator__content--underline"></span>
                                                        </span>
                                                        <span class="mdc-tab__ripple mdc-ripple-upgraded"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="outlet tab-content">
                                <div class="tab-pane active" id="my-promo-new" role="tabpanel"
                                    aria-labelledby="my-promo-tab-new">
                                    <div class="container-b3" id="promo-container">
                                        <!-- Tempat untuk memuat data promo -->
                                    </div>
                                </div>
                                <div class="tab-pane" id="my-bonus-new" role="tabpanel" aria-labelledby="my-bonus-tab-new">
                                    <div class="container-b3" id="bonus-container">
                                        <table id="bonus-table" class="table text-center">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">Latest Date</th>
                                                    <th class="text-center">Spin</th>
                                                    <th class="text-center">Latest Bet</th>
                                                    <th class="text-center">Turnover</th>
                                                    <th class="text-center">Progressive (%)</th>


                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Data akan dimuat di sini -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            $(document).ready(function() {
                function setActiveTab(tabName) {
                    $('.mdc-tab').removeClass('mdc-tab--active-new').attr('aria-selected', 'false');
                    $('.mdc-tab-indicator--active').removeClass('mdc-tab-indicator--active');
                    $('[data-tabname="' + tabName + '"]').addClass('mdc-tab--active-new').attr('aria-selected', 'true');
                    $('[data-tabname="' + tabName + '"]').find('.mdc-tab-indicator').addClass(
                        'mdc-tab-indicator--active');
                    $('.tab-pane').removeClass('active').attr('aria-hidden', 'true');
                    $('#' + tabName).addClass('active').attr('aria-hidden', 'false');
                }

                $('.mdc-tab').on('click', function(e) {
                    e.preventDefault();
                    var tabName = $(this).data('tabname');
                    setActiveTab(tabName);
                    if (tabName === 'my-promo-new') {
                        loadPromoData();
                    } else if (tabName === 'my-bonus-new') {
                        loadBonusData(); // Memanggil loadBonusData saat tab bonus diklik
                    }
                });

                function loadPromoData() {
                    var promoContainer = $('#promo-container');
                    $.ajax({
                        url: "/promo/bonus",
                        type: "POST",
                        dataType: "json",
                        success: function(response) {
                            try {
                                var transaksis = response.transaksis;
                                promoContainer.empty();

                                if (transaksis.length > 0) {
                                    $.each(transaksis, function(index, transaksi) {
                                        var totalBonus = transaksi.nominal *
                                            transaksi.bonus_persentase / 100;
                                        var promoHtml = `
                                    <div class="row my-promo-new">
                                        <div class="col-lg-5 col-xs-12">
                                            <div class="row">
                                                <div class="col-md-4 noSidePadding">
                                                    <p class="lbl">Promosi:</p>
                                                </div>
                                                <div class="col-md-8 noSidePadding">
                                                    <p>${transaksi.bonus.judul}</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-6 col-md-4 noSidePadding">
                                                    <p class="lbl">Jenis Promosi:</p>
                                                </div>
                                                <div class="col-xs-6 col-md-8 noSidePadding">
                                                    <p>${transaksi.bonus.keterangan}</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-6 col-md-4 noSidePadding">
                                                    <p class="lbl">Nominal:</p>
                                                </div>
                                                <div class="col-xs-6 col-md-8 noSidePadding">
                                                    <p>${totalBonus} + ${transaksi.nominal}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-7 col-xs-12">
                                            <div class="row">
                                                <div class="col-xs-7 col-md-4 noSidePadding">
                                                    <p class="lbl">Tanggal Berakhir Promosi:</p>
                                                </div>
                                                <div class="col-xs-5 col-md-8 noSidePadding">
                                                    <p>-</p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-2 col-md-4 noSidePadding">
                                                    <p class="lbl">Status:</p>
                                                </div>
                                                <div class="col-xs-8 col-md-8 noSidePadding">
                                                    <p>
                                                        <span class="label label-default">${transaksi.status == 1 ? '-' : 'Claim'}</span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                                        promoContainer.append(promoHtml);
                                    });
                                } else {
                                    promoContainer.html('<p>Tidak ada data promo yang tersedia.</p>');
                                }
                            } catch (e) {
                                console.error(e);
                                promoContainer.html('<p>Terjadi kesalahan saat memuat data promo.</p>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error(error);
                            promoContainer.html('<p>Terjadi kesalahan saat memuat data promo.</p>');
                        }
                    });
                }

                function loadBonusData() {
                    var bonusContainer = $('#bonus-container');
                    var bonusTable = $('#bonus-table tbody');

                    $.ajax({
                        url: '/turnover',
                        type: 'POST',
                        dataType: 'json',
                        success: function(response) {

                            bonusTable.empty();

                            if (response.spin !== undefined && response.turnover !== undefined && response
                                .progressive !== undefined && response.latest_bet !== undefined && response
                                .latest_date !== undefined) {
                                var progressBar = '<div class="progress-container">' +
                                    '<div class="progress-bar" style="width: ' + response.progressive +
                                    '%;"></div>' +
                                    '</div>';
                                var row = '<tr>' +
                                    '<td>' + response.latest_date + '</td>' +
                                    '<td>' + response.spin + '</td>' +
                                    '<td>' + response.latest_bet + '</td>' +
                                    '<td>' + response.turnover + '</td>' +
                                    '<td>' + progressBar + '</td>' +
                                    '</tr>';
                                bonusTable.append(row);
                            } else {
                                bonusTable.html(
                                    '<tr><td colspan="5">Data turnover tidak tersedia.</td></tr>'
                                );
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error loading bonus data:', error);
                            bonusTable.html(
                                '<tr><td colspan="5">Error loading bonus data. Silakan coba lagi.</td></tr>'
                            );
                        }
                    });
                }

                setActiveTab('my-promo-new');
                loadPromoData();
            });
        </script>
    <?php $__env->stopSection(); ?>
<?php else: ?>
    <?php $__env->startSection('content'); ?>
        <style>
            .progress-container {
                width: 100%;
                background-color: #e0e0e0;
                border-radius: 5px;
                overflow: hidden;
            }

            .progress-bar {
                height: 20px;
                background-color: #76c7c0;
                width: 0;
                border-radius: 5px;
            }
        </style>
        <div class="content my01">
            <div class="container my_promo_view">
                <div class="container-wrapper profile-head">
                    <div class="container container-box noSidePadding">
                        <div class="title fs-lg clearfix text-center">
                            <span class="skew">
                                <span>Promo saya</span>
                            </span>
                        </div>
                        <div class="head-content">
                            <div class="row no-gutters">
                                <div class="col-xs-12">
                                    <div class="mdc-tab-bar" role="tablist">
                                        <div class="mdc-tab-scroller">
                                            <div class="mdc-tab-scroller__scroll-area mdc-tab-scroller__scroll-area--scroll"
                                                style="margin-bottom: 0px;">
                                                <div class="mdc-tab-scroller__scroll-content">
                                                    <a role="tab" href="#" data-tabname="my-promo-new"
                                                        data-active="promomy-promo-new" class="mdc-tab mdc-tab--active-new"
                                                        aria-selected="true" tabindex="0">
                                                        <span class="mdc-tab__content">
                                                            <span class="mdc-tab__text-label">Promo saya</span>
                                                        </span>
                                                        <span class="mdc-tab-indicator mdc-tab-indicator--active">
                                                            <span
                                                                class="mdc-tab-indicator__content mdc-tab-indicator__content--underline"></span>
                                                        </span>
                                                        <span class="mdc-tab__ripple mdc-ripple-upgraded"></span>
                                                    </a>
                                                    <a role="tab" href="#" data-tabname="my-bonus-new"
                                                        data-active="promomy-bonus-new" class="mdc-tab" aria-selected="false"
                                                        tabindex="-1">
                                                        <span class="mdc-tab__content">
                                                            <span class="mdc-tab__text-label">Bonus saya</span>
                                                        </span>
                                                        <span class="mdc-tab-indicator">
                                                            <span
                                                                class="mdc-tab-indicator__content mdc-tab-indicator__content--underline"></span>
                                                        </span>
                                                        <span class="mdc-tab__ripple mdc-ripple-upgraded"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="outlet tab-content">
                                <div class="tab-pane active" id="my-promo-new" role="tabpanel"
                                    aria-labelledby="my-promo-tab-new">
                                    <div class="container-b3" id="promo-container">
                                        <!-- Tempat untuk memuat data promo -->
                                    </div>
                                </div>
                                <div class="tab-pane" id="my-bonus-new" role="tabpanel" aria-labelledby="my-bonus-tab-new">
                                    <div class="container-b3" id="bonus-container">
                                        <div class="table-responsive">
                                            <!-- Tambahkan kelas table-responsive untuk tabel responsif -->
                                            <table id="bonus-table" class="table table-bordered text-center">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 20%;">Latest Date</th>
                                                        <!-- Tambahkan lebar 20% untuk setiap th -->
                                                        <th class="text-center" style="width: 20%;">Spin</th>
                                                        <th class="text-center" style="width: 20%;">Latest Bet</th>
                                                        <th class="text-center" style="width: 20%;">Turnover</th>
                                                        <th class="text-center" style="width: 20%;">Progressive (%)</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!-- Data akan dimuat di sini -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            $(document).ready(function() {
                function setActiveTab(tabName) {
                    // Menghapus kelas dan atribut untuk tab dan panel yang tidak aktif
                    $('.mdc-tab').removeClass('mdc-tab--active-new').attr('aria-selected', 'false');
                    $('.mdc-tab-indicator--active').removeClass('mdc-tab-indicator--active');
                    $('.tab-pane').removeClass('active').attr('aria-hidden', 'true');

                    // Menambahkan kelas dan atribut untuk tab dan panel yang aktif
                    $('[data-tabname="' + tabName + '"]').addClass('mdc-tab--active-new').attr('aria-selected', 'true');
                    $('[data-tabname="' + tabName + '"]').find('.mdc-tab-indicator').addClass(
                        'mdc-tab-indicator--active');
                    $('#' + tabName).addClass('active').attr('aria-hidden', 'false');

                    // Memuat data jika belum dimuat sebelumnya
                    if (!$('#' + tabName).hasClass('loaded')) {
                        if (tabName === 'my-promo-new') {
                            loadPromoData();
                        } else if (tabName === 'my-bonus-new') {
                            loadBonusData();
                        }
                        // Menandai bahwa konten telah dimuat dengan menambahkan kelas 'loaded'
                        $('#' + tabName).addClass('loaded');
                    }
                }

                // Mengaktifkan tab saat diklik atau disentuh
                $('.mdc-tab').on('click touchstart', function(e) {
                    e.preventDefault();
                    var tabName = $(this).data('tabname');
                    setActiveTab(tabName);
                });

                function loadPromoData() {
                    var promoContainer = $('#promo-container');
                    $.ajax({
                        url: "/promo/bonus",
                        type: "POST",
                        dataType: "json",
                        success: function(response) {
                            try {
                                var transaksis = response.transaksis;
                                promoContainer.empty();

                                if (transaksis.length > 0) {
                                    $.each(transaksis, function(index, transaksi) {
                                        var totalBonus = transaksi.nominal *
                                            transaksi.bonus_persentase / 100;
                                        var promoHtml = `
                                <div class="row my-promo-new">
                                    <div class="col-lg-5 col-xs-12">
                                        <div class="row">
                                            <div class="col-md-4 noSidePadding">
                                                <p class="lbl">Promosi:</p>
                                            </div>
                                            <div class="col-md-8 noSidePadding">
                                                <p>${transaksi.bonus.judul}</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xs-6 col-md-4 noSidePadding">
                                                <p class="lbl">Jenis Promosi:</p>
                                            </div>
                                            <div class="col-xs-6 col-md-8 noSidePadding">
                                                <p>${transaksi.bonus.keterangan}</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xs-6 col-md-4 noSidePadding">
                                                <p class="lbl">Nominal:</p>
                                            </div>
                                            <div class="col-xs-6 col-md-8 noSidePadding">
                                                <p>${totalBonus} + ${transaksi.nominal}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-7 col-xs-12">
                                        <div class="row">
                                            <div class="col-xs-7 col-md-4 noSidePadding">
                                                <p class="lbl">Tanggal Berakhir Promosi:</p>
                                            </div>
                                            <div class="col-xs-5 col-md-8 noSidePadding">
                                                <p>-</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xs-2 col-md-4 noSidePadding">
                                                <p class="lbl">Status:</p>
                                            </div>
                                            <div class="col-xs-8 col-md-8 noSidePadding">
                                                <p>
                                                    <span class="label label-default">${transaksi.status == 1 ? '-' : 'Claim'}</span>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                `;
                                        promoContainer.append(promoHtml);
                                    });
                                } else {
                                    promoContainer.html('<p>Tidak ada data promo yang tersedia.</p>');
                                }
                            } catch (e) {
                                console.error(e);
                                promoContainer.html('<p>Terjadi kesalahan saat memuat data promo.</p>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error(error);
                            promoContainer.html('<p>Terjadi kesalahan saat memuat data promo.</p>');
                        }
                    });
                }

                function loadBonusData() {
                    var bonusContainer = $('#bonus-container');
                    var bonusTable = $('#bonus-table tbody');

                    $.ajax({
                        url: '/turnover',
                        type: 'POST',
                        dataType: 'json',
                        success: function(response) {

                            bonusTable.empty();

                            if (response.spin !== undefined && response.turnover !== undefined && response
                                .progressive !== undefined && response.latest_bet !== undefined && response
                                .latest_date !== undefined) {
                                var progressBar = '<div class="progress-container">' +
                                    '<div class="progress-bar" style="width: ' + response.progressive +
                                    '%;"></div>' +
                                    '</div>';
                                var row = '<tr>' +
                                    '<td>' + response.latest_date + '</td>' +
                                    '<td>' + response.spin + '</td>' +
                                    '<td>' + response.latest_bet + '</td>' +
                                    '<td>' + response.turnover + '</td>' +
                                    '<td>' + progressBar + '</td>' +
                                    '</tr>';
                                bonusTable.append(row);
                            } else {
                                bonusTable.html(
                                    '<tr class="text-center"><td colspan="5">Data turnover tidak tersedia.</td></tr>'
                                );
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error loading bonus data:', error);
                            bonusTable.html(
                                '<tr class="text-center"><td colspan="5">Error loading bonus data. Silakan coba lagi.</td></tr>'
                            );
                        }
                    });
                }

                setActiveTab('my-promo-new');
                loadPromoData();
            });
        </script>
    <?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/website/demo/onix/laravel_nexus/resources/views/promo-saya.blade.php ENDPATH**/ ?>