<?php $__env->startSection('content'); ?>

    <div class="card mt-3">
        <div class="card-header">
            Data Deposit Member
        </div>
        <?php if(Session::has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(Session::get('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(Session::has('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(Session::get('error')); ?>

            </div>
        <?php endif; ?>
        <div class="card-body">
            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Username</th>
                        <th>Rek Pengirim</th>
                        <th>Tujuan</th>
                        <th>Deposit</th>
                        <th>Bonus</th>
                        <th>Keterangan</th>
                        <th>Bukti TF</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $transaksi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $transaksis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($transaksis->created_at); ?></td>
                            <td><?php echo e($transaksis->user_name); ?></td>
                            <td><?php echo e($transaksis->rek_pengirim); ?></td>
                            <td><?php echo e($transaksis->bank_tujuan); ?></td>
                            <td>Rp <?php echo e(number_format($transaksis->nominal, 0, ',', '.')); ?></td>
                            <td>
                                <?php
                                    $bonus = $bonuses->where('id', $transaksis->bonus_id)->first();
                                ?>
                                <?php echo e($bonus->judul ?? 'Tidak ada bonus'); ?>

                            </td>
                            <td><?php echo e($transaksis->keterangan); ?></td>
                            <td>
                                <?php if($transaksis->bukti_transfer): ?>
                                    <a href="<?php echo e(asset('storage/' . $transaksis->bukti_transfer)); ?>" target="_blank">Lihat Bukti</a>
                                <?php else: ?>
                                    Tidak Ada Bukti
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($transaksis->status == 1): ?>
                                    <!-- Tombol untuk memunculkan modal konfirmasi -->
                                    <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#confirmModal-<?php echo e($transaksis->id); ?>">
                                        Konfirmasi
                                    </button>

                                    <form action="<?php echo e(route('depo.reject', $transaksis->id)); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <button type="submit" class="btn btn-sm btn-warning">Reject</button>
                                    </form>
                                <?php elseif($transaksis->status == 2): ?>
                                    <span style="color: rgb(21, 128, 0)"><strong>Sukses</strong></span>
                                <?php elseif($transaksis->status == 3): ?>
                                    <span style="color: rgb(128, 0, 0)"><strong>Reject</strong></span>
                                <?php endif; ?>
                            </td>
                        </tr>

                        <!-- Modal Konfirmasi -->
                        <div class="modal fade" id="confirmModal-<?php echo e($transaksis->id); ?>" tabindex="-1" role="dialog" aria-labelledby="confirmModalLabel-<?php echo e($transaksis->id); ?>" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="confirmModalLabel-<?php echo e($transaksis->id); ?>">Konfirmasi Transaksi</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        Apakah Anda yakin ingin mengonfirmasi transaksi ini? Tindakan ini tidak dapat dibatalkan!
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Tidak</button>
                                        <form action="<?php echo e(route('depo.confirm', $transaksis->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <button type="submit" class="btn btn-primary">Ya, Konfirmasi!</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10" class="text-center">Tidak ada transaksi ditemukan</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/runningWeb/resources/views/admin/deposit/deposit.blade.php ENDPATH**/ ?>