<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($setting->nama_web ?? 'Admin'); ?> - Admin Panel</title>
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/plugins/fontawesome-free/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/../../Admin/dist/css/adminlte.min.css')); ?>">
</head>

<body class="hold-transition login-page" 
      style="background: url('https://png.pngtree.com/thumb_back/fh260/background/20211118/pngtree-technology-round-dashboard-image_908915.jpg') no-repeat center center fixed; background-size: cover;">
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <div class="login-box">
        <div class="card card-outline card-primary">
            <div class="card-header text-center">
                <img src="/storage/<?php echo e($setting->logo ?? 'x'); ?>" width="200px" alt="">
            </div>
            <div class="card-body">
                <p class="login-box-msg">Silahkan login dengan akun admin</p>
                <form action="<?php echo e(route('admins.login')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="input-group mb-3">
                        <input type="name" name="name" class="form-control" placeholder="Username">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="password" name="password" class="form-control" placeholder="Password">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-8">
                            <div class="icheck-primary">
                                <input type="checkbox" id="remember" name="remember">
                                <label for="remember">
                                    Remember Me
                                </label>
                            </div>
                        </div>
                        <div class="col-4">
                            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                        </div>
                    </div>
                    <div class="row mt-3">
                      <a href="https://t.me/Ngaming_api" 
                      target="_blank" 
                      style="display: block; text-align: center; width: 100%; color: #9b9b9b; text-shadow: 0px 0px 4px rgba(0, 0, 0, 0.5); text-decoration: none;">
                       © Wokakse Productions ®
                      </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="<?php echo e(asset('/../../Admin/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/../../Admin/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
</body>

</html>
<?php /**PATH /home/pstfrggd/2api.bali2000.com/resources/views/auth/admin.blade.php ENDPATH**/ ?>