<?php
use App\Http\Api\fiver;
?>

<?php $__env->startSection('content'); ?>
    <div class="card mt-3">
        <div class="card-header">
            Data Member
        </div>
        <div class="card-body">
            <?php echo $__env->make('admin.layouts.msg_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="table-responsive">
                <table id="example2" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Tanggal</th>
                            <th>Username</th>
                            <th>Ref</th>
                            <th>Saldo</th>
                            <th>Email</th>
                            <th>No WA</th>
                            <th>Bank</th>
                            <th>Nama Rekening</th>
                            <th>Nomor Rekening</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $saldo = isset($user->saldo[0]) ? $user->saldo[0]->saldo : 0;
                            ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($user->updated_at); ?> </td>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->ref_code); ?></td>
                                <td><?php echo e(number_format($saldo)); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->telp); ?></td>
                                <td><?php echo e($user->bank ?? ''); ?></td>
                                <td><?php echo e($user->nama_rek); ?></td>
                                <td><?php echo e($user->no_rek); ?></td>
                                <td>
                                    <button data-toggle="modal" data-target="#ubah<?php echo e($user->id); ?>" type="button"
                                        class="btn btn-primary"><i class="fas fa-pen"></i></button>
                                </td>
                            </tr>

                            <div class="modal fade" id="ubah<?php echo e($user->id); ?>" tabindex="-1" role="dialog"
                                aria-labelledby="modaledit<?php echo e($user->id); ?>" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <form action="<?php echo e(route('saldo.update', $user->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="modaledit<?php echo e($user->id); ?>">Konfirmasi</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- Form untuk mengubah data user -->
                                                <div class="form-group">
                                                    <label for="name">Nama</label>
                                                    <input type="text" class="form-control" id="name" name="name"
                                                        value="<?php echo e($user->name); ?>">
                                                </div>
                                                <div class="form-group">
                                                    <label for="saldo">Saldo</label>
                                                    <input type="text" class="form-control" id="text" name="saldo"
                                                        value="<?php echo e($saldo); ?>">
                                                </div>
                                                <div class="form-group">
                                                    <label for="action">Pilih Tindakan</label>
                                                    <select class="form-control" id="action" name="action">
                                                        <option value="none" selected disabled>-- Pilih Tindakan --
                                                        </option>
                                                        <option value="deposit">Tambah Saldo</option>
                                                        <option value="withdraw">Tarik Saldo</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                </button>
                                                <button type="submit" class="btn btn-warning">Simpan Perubahan</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pstfrggd/2api.bali2000.com/resources/views/admin/data_member/inject.blade.php ENDPATH**/ ?>