<?php

namespace Illuminate\Foundation\Auth;

use App\Models\Bank;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

trait RegistersUsers
{
    use RedirectsUsers;

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\View\View
     */
    public function showRegistrationForm(Request $request)
    {
      	if ($request->has('ref')) {
            session(['referral_code' => $request->get('ref')]);
        }
        
        $referralCode = session('referral_code');
        
      	$bank = Bank::where('type', 1)->get();
        $ewallet = Bank::where('type', 2)->get();
        return view('auth.register', compact('bank', 'ewallet'));
    }

    /**
     * Handle a registration request for the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $this->validator($request->all())->validate();

        // Panggil event Registered, tapi tidak melakukan login
        event(new Registered($user = $this->create($request->all())));

        if ($user instanceof User) {
            $this->guard()->login($user);
        } else {
            return redirect()->back()->with('error', 'Username sudah digunakan.');
        }

        if ($response = $this->registered($request, $user)) {
            return $response;
        }

        return $request->wantsJson()
                    ? new JsonResponse([], 201)
                    : redirect($this->redirectPath());
    }

    /**
     * Get the guard to be used during registration.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard();
    }

    /**
     * The user has been registered.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function registered(Request $request, $user)
    {
        //
    }
}
